package backend_test

import (
	"errors"
	"testing"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/backend"
	"code.justin.tv/feeds/following-service/mocks"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/suite"
)

type RestoreAllFollowsSuite struct {
	suite.Suite
	backend backend.Backend
}

func (suite *RestoreAllFollowsSuite) SetupTest() {
	client := &mocks.TwitchVXGraphDBECS{}
	suite.backend = backend.Backend{
		GraphDBFultonClient: client,
		ErrorLogger:         NewNoopErrorLogger(),
	}
	client.On("BulkEdgeUpdate", mock.Anything, &graphdbFulton.BulkEdgeUpdateRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "1",
		},
		EdgeType:    backend.HiddenFollowsKind,
		NewEdgeType: backend.FollowsKind,
	}).Return(nil, nil)
	client.On("BulkEdgeUpdate", mock.Anything, &graphdbFulton.BulkEdgeUpdateRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "1",
		},
		EdgeType:    backend.HiddenFollowersKind,
		NewEdgeType: backend.FollowersKind,
	}).Return(nil, nil)
	client.On("BulkEdgeUpdate", mock.Anything, &graphdbFulton.BulkEdgeUpdateRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "2",
		},
		EdgeType:    backend.HiddenFollowsKind,
		NewEdgeType: backend.FollowsKind,
	}).Return(nil, nil)
	client.On("BulkEdgeUpdate", mock.Anything, &graphdbFulton.BulkEdgeUpdateRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "2",
		},
		EdgeType:    backend.HiddenFollowersKind,
		NewEdgeType: backend.FollowersKind,
	}).Return(nil, errors.New("broken"))
	client.On("BulkEdgeUpdate", mock.Anything, &graphdbFulton.BulkEdgeUpdateRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "3",
		},
		EdgeType:    backend.HiddenFollowsKind,
		NewEdgeType: backend.FollowsKind,
	}).Return(nil, nil).Run(func(args mock.Arguments) { panic("panic") })
	client.On("BulkEdgeUpdate", mock.Anything, &graphdbFulton.BulkEdgeUpdateRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "3",
		},
		EdgeType:    backend.HiddenFollowersKind,
		NewEdgeType: backend.FollowersKind,
	}).Return(nil, nil)
}

func (suite *RestoreAllFollowsSuite) TestSuccessfulRequest() {
	err := suite.backend.RestoreAllFollows(nil, "1")
	suite.Nil(err)
}

func (suite *RestoreAllFollowsSuite) TestFailedRequest() {
	err := suite.backend.RestoreAllFollows(nil, "2")
	suite.NotNil(err)
	suite.EqualError(err, "broken")
}

func (suite *RestoreAllFollowsSuite) TestPanic() {
	err := suite.backend.RestoreAllFollows(nil, "3")
	suite.NotNil(err)
	suite.EqualError(err, "graphdb_restore_all_follows circuit panic=panic")
}

func TestRestoreeAllFollowsSuite(t *testing.T) {
	suite.Run(t, new(RestoreAllFollowsSuite))
}
