package backend

import (
	"context"
	"fmt"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/clients"
	"code.justin.tv/feeds/following-service/header"
	"github.com/afex/hystrix-go/hystrix"
)

func (b Backend) UpdateFollow(ctx context.Context, fromUserID string, targetUserID string, blockNotifications bool) error {
	err := hystrix.Do(clients.HystrixGraphDBUpdate, func() (err error) {
		defer func() {
			if p := recover(); p != nil {
				err = fmt.Errorf("%s circuit panic=%v", clients.HystrixGraphDBUpdate, p)
			}
		}()

		_, gdbErr := b.GraphDBFultonClient.EdgeUpdate(ctx, &graphdbFulton.EdgeUpdateRequest{
			Edge: &graphdbFulton.Edge{
				From: &graphdbFulton.Node{
					Type: UserKind,
					Id:   fromUserID,
				},
				To: &graphdbFulton.Node{
					Type: UserKind,
					Id:   targetUserID,
				},
				Type: FollowsKind,
			},
			Data: &graphdbFulton.DataBag{
				Bools: map[string]bool{
					"block_notifications": blockNotifications,
				},
			},
		})
		return gdbErr
	}, nil)
	if err != nil {
		return err
	}

	clientID := header.GetHeaderFromContext(ctx, header.ClientIDHeader)
	deviceID := header.GetHeaderFromContext(ctx, header.DeviceIDHeader)

	go b.sendSpadeNotificationStatusUpdateMessage(targetUserID, fromUserID, !blockNotifications, clientID, deviceID)

	return nil
}
