package clients

import (
	"context"
	"fmt"
	"log"

	"code.justin.tv/growth/receiver/proto/receiver"
	"github.com/afex/hystrix-go/hystrix"
	"github.com/pkg/errors"
)

const (
	EventName = "followeradd"
)

type DartClient interface {
	PublishNotification(context context.Context, follower, followee string) error
}

type dartImpl struct {
	DartReceiver receiver.Receiver
}

func NewDartClient(DartReceiver receiver.Receiver) DartClient {
	return &dartImpl{
		DartReceiver: DartReceiver,
	}
}

func (d *dartImpl) PublishNotification(ctx context.Context, follower, followee string) error {
	var resp *receiver.PublishNotificationResponse
	err := hystrix.Do(HystrixDartPublishNotification, func() (err error) {
		defer func() {
			if p := recover(); p != nil {
				err = fmt.Errorf("%s circuit panic=%v", HystrixDartPublishNotification, p)
			}
		}()

		resp, err = d.DartReceiver.PublishNotification(ctx, &receiver.PublishNotificationRequest{
			SenderId: follower,
			Recipient: &receiver.PublishNotificationRequest_RecipientId{
				RecipientId: followee,
			},
			NotificationType: EventName,
			Metadata: map[string]string{
				"follower_id": follower,
			},
		})
		return err
	}, nil)
	if err != nil {
		return errors.Wrap(err, "error publishing a followeradd message to receiver")
	} else if resp == nil {
		log.Println("received a nil response publishing a followeradd message to receiver")
	}

	return nil
}
