package clients

import (
	"time"

	"code.justin.tv/common/golibs/errorlogger"
	"code.justin.tv/discovery/experiments"
	"code.justin.tv/discovery/experiments/experiment"
	"github.com/pkg/errors"
)

const (
	CountRolloutExperimentName      = "following_service_count_rollout"
	CountRolloutExperimentID        = "957c74ff-8a3e-43c2-9cb3-606f32c5b6d0"
	GetFollowRolloutExperimentName  = "following_service_get_follow_rollout"
	GetFollowRolloutExperimentID    = "d624c623-3d66-44fb-b084-89c4d33c3a31"
	UpsertListRolloutExperimentName = "following_service_upsert_list_rollout"
	UpsertListRolloutExperimentID   = "50fca003-6e39-46aa-a83d-33638654f348"
	CacheRemovalExperimentName      = "following_service_cache_removal"
	CacheRemovalExperimentID        = "64bfcb47-6285-4036-ab8f-0a8634d4f352"
)

func NewExperimentClient(logger errorlogger.ErrorLogger) (experiments.Experiments, error) {
	exps, err := experiments.New(experiments.Config{
		DisableSpadeTracking: true,
		Platform:             experiment.LegacyPlatform,
		ErrorHandler: func(err error) {
			logger.Error(errors.Wrap(err, "error occurred in experiments"))
		},
		PollingInterval: 30 * time.Second,
	})
	if err != nil {
		return nil, errors.Wrap(err, "unable to setup experiment client")
	}

	exps.RegisterDefault(experiment.UserType, CountRolloutExperimentName, CountRolloutExperimentID, "control")
	exps.RegisterDefault(experiment.UserType, GetFollowRolloutExperimentName, GetFollowRolloutExperimentID, "control")
	exps.RegisterDefault(experiment.UserType, UpsertListRolloutExperimentName, UpsertListRolloutExperimentID, "control")
	exps.RegisterDefault(experiment.UserType, CacheRemovalExperimentName, CacheRemovalExperimentID, "control")
	return exps, nil
}
