package clients

import (
	"github.com/afex/hystrix-go/hystrix"
	metricCollector "github.com/afex/hystrix-go/hystrix/metric_collector"
	"github.com/afex/hystrix-go/plugins"
)

const (
	// HystrixCohesionCreate is a hystrix create command
	HystrixCohesionCreate = "cohesion_create"
	// HystrixCohesionCountFollows is a hystrix count command
	HystrixCohesionCountFollows = "cohesion_countfollows"
	// HystrixCohesionListFollows is a hystrix list command
	HystrixCohesionListFollows = "cohesion_listfollows"
	// HystrixCohesionCountFollowers is a hystrix count command
	HystrixCohesionCountFollowers = "cohesion_countfollowers"
	// HystrixCohesionListFollowers is a hystrix list command
	HystrixCohesionListFollowers = "cohesion_listfollowers"
	// HystrixCohesionGet is a hystrix get command
	HystrixCohesionGet = "cohesion_get"
	// HystrixCohesionGetBatchFollows is a hystrix get command
	HystrixCohesionGetBatchFollows = "cohesion_getbatchfollows"
	// HystrixCohesionDelete is a hystrix delete command
	HystrixCohesionDelete = "cohesion_delete"
	// HystrixCohesionBulkDelete is a hystrix bulk delete command
	HystrixCohesionBulkDelete = "cohesion_bulk_delete"
	// HystrixCohesionHideAllFollows is a hystrix bulk hide command
	HystrixCohesionHideAllFollows = "cohesion_hide_all_follows"
	// HystrixCohesionRestoreAllFollows is a hystrix bulk restore command
	HystrixCohesionRestoreAllFollows = "cohesion_restore_all_follows"
	// HystrixCohesionHideAllFollowers is a hystrix bulk hide command
	HystrixCohesionHideAllFollowers = "cohesion_hide_all_followers"
	// HystrixCohesionRestoreAllFollowers is a hystrix bulk restore command
	HystrixCohesionRestoreAllFollowers = "cohesion_restore_all_followers"
	// HystrixCohesionCacheCountFollows memcache for count follows
	HystrixCohesionCacheCountFollows = "CacheCountFollows"
	// HystrixCohesionCacheCountFollowers memcache for count followers
	HystrixCohesionCacheCountFollowers = "CacheCountFollowers"
	// HystrixCohesionCacheListFollowers memcache for list followers
	HystrixCohesionCacheListFollowers = "CacheListFollowers"
	// HystrixCohesionCacheListFollows memcache for list follows
	HystrixCohesionCacheListFollows = "CacheListFollows"
	// HystrixCohesionDefaultTimeout is a default timeout, in milliseconds, for a cohesion call
	HystrixCohesionDefaultTimeout = 3000
	// HystrixCohesionDefaultSleepWindow is the default amount of time, in milliseconds, to sleep until recovery is checked
	HystrixCohesionDefaultSleepWindow = 5000
	// HystrixCohesionDefaultErrorThreshold is a default threshold of errors required for a circuit to open
	HystrixCohesionDefaultErrorThreshold = 50
	// HystrixCohesionDefaultRequestThreshold is the default minimum amount of requests needed before a circuit can trip
	HystrixCohesionDefaultRequestThreshold = 20
	// HystrixCohesionDefaultMaxConcurrency is a default for many cohesion commands can run concurrently
	HystrixCohesionDefaultMaxConcurrency = 100

	// HystrixGraphDBCreate is a hystrix create command
	HystrixGraphDBCreate = "graphdb_create"
	// HystrixGraphDBDelete is a hystrix create command
	HystrixGraphDBDelete = "graphdb_delete"
	// HystrixGraphDBCountFollows is a hystrix count command
	HystrixGraphDBCountFollows = "graphdb_countfollows"
	// HystrixGraphDBCountFollowers is a hystrix count command
	HystrixGraphDBCountFollowers = "graphdb_countfollowers"
	// HystrixGraphDBGetFollow is a hystrix get command
	HystrixGraphDBGetFollow = "graphdb_getfollow"
	// HystrixGraphDBListFollows is a hystrix list command
	HystrixGraphDBListFollows = "graphdb_listfollows"
	// HystrixGraphDBListFollowers is a hystrix list command
	HystrixGraphDBListFollowers = "graphdb_listfollowers"
	// HystricGraphDBGetBatchFollows
	HystrixGraphDBGetBatchFollows = "graphdb_getbatchfollows"
	// HystrixGraphDBCacheCountFollows memcache for count follows
	HystrixGraphDBCacheCountFollows = "cache_graphdb_countfollows"
	// HystrixGraphDBCacheCountFollowers memcache for count followers
	HystrixGraphDBCacheCountFollowers = "cache_graphdb_countfollowers"
	// HystrixGraphDBCacheListFollows memcache for list follows
	HystrixGraphDBCacheListFollows = "cache_graphdb_listfollows"
	// HystrixGraphDBCacheListFollowers memcache for list followers
	HystrixGraphDBCacheListFollowers = "cache_graphdb_listfollowers"
	// HystrixGraphDbRestoreAllFollows is a hystrix bulk restore command
	HystrixGraphDBRestoreAllFollows = "graphdb_restore_all_follows"
	// HystrixGraphDBHideAllFollows is a hystrix bulk hide command
	HystrixGraphDBHideAllFollows = "graphdb_hide_all_follows"
	// HystrixGraphDBRestoreAllFollow is a hystrix bulk restore command
	HystrixGraphDBRestoreAllFollowers = "graphdb_restore_all_followers"
	// HystrixGraphDBHideAllFollowers is a hystrix bulk hide command
	HystrixGraphDBHideAllFollowers = "graphdb_hide_all_followers"
	//HystrixGraphDBBulkDelete is a bulk delete command
	HystrixGraphDBBulkDelete = "graphdb_bulk_delete"
	// HystrixGraphDBUpdate is a update command
	HystrixGraphDBUpdate = "graphdb_update"
	// HystrixGraphDBDefaultTimeout is a default timeout, in milliseconds, for a graphdb call
	HystrixGraphDBDefaultTimeout = 3000
	// HystrixGraphDBDefaultSleepWindow is the default amount of time, in milliseconds, to sleep until recovery is checked
	HystrixGraphDBDefaultSleepWindow = 5000
	// HystrixGraphDBDefaultErrorThreshold is a default threshold of errors required for a circuit to open
	HystrixGraphDBDefaultErrorThreshold = 50
	// HystrixGraphDBDefaultRequestThreshold is the default minimum amount of requests needed before a circuit can trip
	HystrixGraphDBDefaultRequestThreshold = 20
	// HystrixGraphDBDefaultMaxConcurrency is a default for many graphdb commands can run concurrently
	HystrixGraphDBDefaultMaxConcurrency = 100
	// Batch settings
	HystrixGraphDBBatch                      = "graphdb_batch_v2"
	HystrixGraphDBDefaultBatchTimeout        = 60000
	HystrixGraphDBDefaultBatchMaxConcurrency = 10

	// HystrixSNSPublish is a command which publishes a message to an SNS topic
	HystrixSNSPublish = "sns_publish"
	// HystrixSNSDefaultTimeout is a default timeout, in milliseconds, for an SNS call
	HystrixSNSDefaultTimeout = 2000
	// HystrixSNSDefaultSleepWindow is the default amount of time, in milliseconds, to sleep until recovery is checked
	HystrixSNSDefaultSleepWindow = 5000
	// HystrixSNSDefaultErrorThreshold is a default threshold of errors required for a circuit to open
	HystrixSNSDefaultErrorThreshold = 50
	// HystrixSNSDefaultRequestThreshold is the default minimum amount of requests needed before a circuit can trip
	HystrixSNSDefaultRequestThreshold = 20
	// HystrixSNSDefaultMaxConcurrency is a default for many sns commands can run concurrently
	HystrixSNSDefaultMaxConcurrency = 100

	// HystrixPubSubPublish is a command which publishes a message to a PubSub topic
	HystrixPubSubPublish = "pubsub_publish"
	// HystrixPubSubDefaultTimeout is a default timeout, in milliseconds, for a PubSub call
	HystrixPubSubDefaultTimeout = 2000
	// HystrixPubSubDefaultSleepWindow is the default amount of time, in milliseconds, to sleep until recovery is checked
	HystrixPubSubDefaultSleepWindow = 5000
	// HystrixPubSubDefaultErrorThreshold is a default threshold of errors required for a circuit to open
	HystrixPubSubDefaultErrorThreshold = 50
	// HystrixPubSubDefaultRequestThreshold is the default minimum amount of requests needed before a circuit can trip
	HystrixPubSubDefaultRequestThreshold = 20
	// HystrixPubSubDefaultMaxConcurrency is a default for how many pubsub commands can run concurrently
	HystrixPubSubDefaultMaxConcurrency = 100

	// HystrixUsersServiceGetUserByID is for the UsersService client's GetUserByID method
	HystrixUsersServiceGetUserByID = "usersservice_getuserbyid"
	// HystrixUsersServiceDefaultTimeout is a default timeout, in milliseconds, for a UsersService call
	HystrixUsersServiceDefaultTimeout = 300
	// HystrixUsersServiceDefaultSleepWindow is the default amount of time, in milliseconds, to sleep until recovery is checked
	HystrixUsersServiceDefaultSleepWindow = 5000
	// HystrixUsersServiceDefaultErrorThreshold is a default threshold of errors required for a circuit to open
	HystrixUsersServiceDefaultErrorThreshold = 50
	// HystrixUsersServiceDefaultRequestThreshold is the default minimum amount of requests needed before a circuit can trip
	HystrixUsersServiceDefaultRequestThreshold = 20
	// HystrixUsersServiceDefaultMaxConcurrency is a default for how many UsersService commands can run concurrently
	HystrixUsersServiceDefaultMaxConcurrency = 200

	// HystrixEventBusPublish is a command which publishes a message to an EventBus topic
	HystrixEventBusPublish = "eventbus_publish"
	// HystrixEventBusDefaultTimeout is a default timeout, in milliseconds, for an EventBus call
	HystrixEventBusDefaultTimeout = 2000
	// HystrixEventBusDefaultSleepWindow is the default amount of time, in milliseconds, to sleep until recovery is checked
	HystrixEventBusDefaultSleepWindow = 5000
	// HystrixEventBusDefaultErrorThreshold is a default threshold of errors required for a circuit to open
	HystrixEventBusDefaultErrorThreshold = 50
	// HystrixEventBusDefaultRequestThreshold is the default minimum amount of requests needed before a circuit can trip
	HystrixEventBusDefaultRequestThreshold = 20
	// HystrixEventBusDefaultMaxConcurrency is a default for many sns commands can run concurrently
	HystrixEventBusDefaultMaxConcurrency = 100

	// HystrixZumaIsBlocked is for the Zuma client's isBlocked method
	HystrixZumaIsBlocked = "zuma_isblocked"
	// HystrixZumaDefaultTimeout is a default timeout, in milliseconds, for a Zuma call
	HystrixZumaDefaultTimeout = 300
	// HystrixZumaDefaultSleepWindow is the default amount of time, in milliseconds, to sleep until recovery is checked
	HystrixZumaDefaultSleepWindow = 5000
	// HystrixZumaDefaultErrorThreshold is a default threshold of errors required for a circuit to open
	HystrixZumaDefaultErrorThreshold = 50
	// HystrixZumaDefaultRequestThreshold is the default minimum amount of requests needed before a circuit can trip
	HystrixZumaDefaultRequestThreshold = 20
	// HystrixZumaDefaultMaxConcurrency is a default for many Zuma commands can run concurrently
	HystrixZumaDefaultMaxConcurrency = 200

	// HystrixDartPublishNotification is for the DartClient receiver's PublishNotification method
	HystrixDartPublishNotification = "dart_publish_notification"
	// HystrixDartDefaultTimeout is a default timeout, in milliseconds, for a DartClient call
	HystrixDartDefaultTimeout = 500
	// HystrixDartDefaultSleepWindow is the default amount of time, in milliseconds, to sleep until recovery is checked
	HystrixDartDefaultSleepWindow = 5000
	// HystrixDartDefaultErrorThreshold is a default threshold of errors required for a circuit to open
	HystrixDartDefaultErrorThreshold = 50
	// HystrixDartDefaultRequestThreshold is the default minimum amount of requests needed before a circuit can trip
	HystrixDartDefaultRequestThreshold = 20
	// HystrixDartDefaultMaxConcurrency is a default for many Dart commands can run concurrently
	HystrixDartDefaultMaxConcurrency = 200

	// HystrixFollowBotDetectionClassify is for the FollowBotDetection client's Classify method
	HystrixFollowBotDetectionClassify = "followbotdetection_classify"
	// HystrixFollowBotDetectionDefaultTimeout is a default timeout, in milliseconds, for a FollowBotDetection call
	HystrixFollowBotDetectionDefaultTimeout = 200
	// HystrixFollowBotDetectionDefaultSleepWindow is the default amount of time, in milliseconds, to sleep until recovery is checked
	HystrixFollowBotDetectionDefaultSleepWindow = 5000
	// HystrixFollowBotDetectionDefaultErrorThreshold is a default threshold of errors required for a circuit to open
	HystrixFollowBotDetectionDefaultErrorThreshold = 50
	// HystrixFollowBotDetectionDefaultRequestThreshold is the default minimum amount of requests needed before a circuit can trip
	HystrixFollowBotDetectionDefaultRequestThreshold = 20
	// HystrixFollowBotDetectionDefaultMaxConcurrency is a default for many FollowBotDetection commands can run concurrently
	HystrixFollowBotDetectionDefaultMaxConcurrency = 200
)

// InitHystrix configures hystrix commands.
func InitHystrix(config *plugins.StatsdCollectorConfig) error {
	hystrix.ConfigureCommand(HystrixCohesionCountFollows, hystrix.CommandConfig{
		Timeout:                HystrixCohesionDefaultTimeout,
		SleepWindow:            HystrixCohesionDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixCohesionDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixCohesionDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixCohesionDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixCohesionListFollows, hystrix.CommandConfig{
		Timeout:                HystrixCohesionDefaultTimeout,
		SleepWindow:            HystrixCohesionDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixCohesionDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixCohesionDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixCohesionDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixCohesionGet, hystrix.CommandConfig{
		Timeout:                HystrixCohesionDefaultTimeout,
		SleepWindow:            HystrixCohesionDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixCohesionDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixCohesionDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixCohesionDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixCohesionGetBatchFollows, hystrix.CommandConfig{
		Timeout:                HystrixCohesionDefaultTimeout,
		SleepWindow:            HystrixCohesionDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixCohesionDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixCohesionDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixCohesionDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixCohesionCreate, hystrix.CommandConfig{
		Timeout:                HystrixCohesionDefaultTimeout,
		SleepWindow:            HystrixCohesionDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixCohesionDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixCohesionDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixCohesionDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixCohesionDelete, hystrix.CommandConfig{
		Timeout:                HystrixCohesionDefaultTimeout,
		SleepWindow:            HystrixCohesionDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixCohesionDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixCohesionDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixCohesionDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixCohesionBulkDelete, hystrix.CommandConfig{
		Timeout:                HystrixCohesionDefaultTimeout,
		SleepWindow:            HystrixCohesionDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixCohesionDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixCohesionDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixCohesionDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixCohesionHideAllFollowers, hystrix.CommandConfig{
		Timeout:                HystrixCohesionDefaultTimeout,
		SleepWindow:            HystrixCohesionDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixCohesionDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixCohesionDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixCohesionDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixCohesionRestoreAllFollowers, hystrix.CommandConfig{
		Timeout:                HystrixCohesionDefaultTimeout,
		SleepWindow:            HystrixCohesionDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixCohesionDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixCohesionDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixCohesionDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixCohesionHideAllFollows, hystrix.CommandConfig{
		Timeout:                HystrixCohesionDefaultTimeout,
		SleepWindow:            HystrixCohesionDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixCohesionDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixCohesionDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixCohesionDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixCohesionRestoreAllFollows, hystrix.CommandConfig{
		Timeout:                HystrixCohesionDefaultTimeout,
		SleepWindow:            HystrixCohesionDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixCohesionDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixCohesionDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixCohesionDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixCohesionListFollowers, hystrix.CommandConfig{
		Timeout:                HystrixCohesionDefaultTimeout,
		SleepWindow:            HystrixCohesionDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixCohesionDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixCohesionDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixCohesionDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixCohesionCountFollowers, hystrix.CommandConfig{
		Timeout:                HystrixCohesionDefaultTimeout,
		SleepWindow:            HystrixCohesionDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixCohesionDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixCohesionDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixCohesionDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBCreate, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBDelete, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBCountFollows, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBCountFollowers, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBGetFollow, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBListFollowers, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBListFollows, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBGetBatchFollows, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBRestoreAllFollows, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBHideAllFollows, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBRestoreAllFollowers, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBHideAllFollowers, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBBulkDelete, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBUpdate, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixGraphDBBatch, hystrix.CommandConfig{
		Timeout:                HystrixGraphDBDefaultBatchTimeout,
		SleepWindow:            HystrixGraphDBDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixGraphDBDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixGraphDBDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixGraphDBDefaultBatchMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixSNSPublish, hystrix.CommandConfig{
		Timeout:                HystrixSNSDefaultTimeout,
		SleepWindow:            HystrixSNSDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixSNSDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixSNSDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixSNSDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixPubSubPublish, hystrix.CommandConfig{
		Timeout:                HystrixPubSubDefaultTimeout,
		SleepWindow:            HystrixPubSubDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixPubSubDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixPubSubDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixPubSubDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixUsersServiceGetUserByID, hystrix.CommandConfig{
		Timeout:                HystrixUsersServiceDefaultTimeout,
		SleepWindow:            HystrixUsersServiceDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixUsersServiceDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixUsersServiceDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixUsersServiceDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixEventBusPublish, hystrix.CommandConfig{
		Timeout:                HystrixEventBusDefaultTimeout,
		SleepWindow:            HystrixEventBusDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixEventBusDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixEventBusDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixEventBusDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixZumaIsBlocked, hystrix.CommandConfig{
		Timeout:                HystrixZumaDefaultTimeout,
		SleepWindow:            HystrixZumaDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixZumaDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixZumaDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixZumaDefaultMaxConcurrency,
	})

	hystrix.ConfigureCommand(HystrixDartPublishNotification, hystrix.CommandConfig{
		Timeout:                HystrixDartDefaultTimeout,
		SleepWindow:            HystrixDartDefaultSleepWindow,
		ErrorPercentThreshold:  HystrixDartDefaultErrorThreshold,
		RequestVolumeThreshold: HystrixDartDefaultRequestThreshold,
		MaxConcurrentRequests:  HystrixDartDefaultMaxConcurrency,
	})

	memcachedHystrix := []string{
		HystrixCohesionCacheCountFollows,
		HystrixCohesionCacheCountFollowers,
		HystrixCohesionCacheListFollowers,
		HystrixCohesionCacheListFollows,
		HystrixGraphDBCacheCountFollows,
		HystrixGraphDBCacheCountFollowers,
		HystrixGraphDBCacheListFollows,
		HystrixGraphDBCacheListFollowers,
	}

	for _, hystrixName := range memcachedHystrix {
		hystrix.ConfigureCommand(hystrixName, hystrix.CommandConfig{
			Timeout:                HystrixCohesionDefaultTimeout,
			SleepWindow:            HystrixCohesionDefaultSleepWindow,
			ErrorPercentThreshold:  HystrixCohesionDefaultErrorThreshold,
			RequestVolumeThreshold: HystrixCohesionDefaultRequestThreshold,
			MaxConcurrentRequests:  HystrixCohesionDefaultMaxConcurrency,
		})
	}

	c, err := plugins.InitializeStatsdCollector(config)
	if err != nil {
		return err
	}
	metricCollector.Registry.Register(c.NewStatsdCollector)
	return nil
}
