#!/usr/bin/env bash
set -e
set -x

# MAX_TIME is a threshold for deployment validation. Anything older than
# this number of seconds is considered "too old" at this stage, and will
# make deployments fail. This check is particularly useful during the initial
# migration to Chasqui, where the old daemontools service was deployed
# with Courier.
MAX_TIME=50
EXPECTED_SERVICES_NUM=1

SVSTAT=$(sudo /usr/bin/svstat /etc/service/following-service )
echo "$SVSTAT"

RUNNING_SERVICES_NUM=$(echo "$SVSTAT" | grep -E ': up \(pid [0-9]+\) ' | wc -l | xargs)
if test $RUNNING_SERVICES_NUM -ne $EXPECTED_SERVICES_NUM; then
    echo "ERROR: Expected $EXPECTED_SERVICES_NUM running services, but got $RUNNING_SERVICES_NUM"
    exit 1
fi

OLD=$(echo "$SVSTAT" | gawk 'match($0, /^(.*): up \(pid [0-9]+\) ([0-9]+) seconds/, arr) { if (arr[2] >=max_time) { print arr[1]}}' max_time=$MAX_TIME)
if test -n "$OLD"; then
    echo "ERROR: Services not started in the current deployment:" $OLD
    exit 1
fi