# Deploying

## Please read before deploying

[Clean Deploy](https://deploy.xarth.tv/#/feeds/following-service)

Almost always deploy to staging, then production-canary, and then production.

The canary environment deploys to one host

## Deploy Steps

1. Work on change and test in staging
1. Open Pull Request and get change reviewed and approved
1. Merge your topic branch into master and then delete your topic branch
1. Deploy master to Canary
1. Wait for the Canary deployment to succeed
1. Watch the [dashboards](https://grafana.xarth.tv/dashboard/db/following-service) and [rollbar](https://rollbar.com/Twitch/Following/) for any errors
    1. **Note:** Canary metrics/errors will be under "production"
    1. If you find errors: **Rollback and deploy previous version to Canary**
1. Deploy master to production
1. Wait for the production deployment to succeed
1. Watch the [dashboards](https://grafana.xarth.tv/dashboard/db/following-service) and [rollbar](https://rollbar.com/Twitch/Following/) for any errors
    1. If you find errors: **Rollback and deploy previous version to Canary and Production**

# Production

These links are for monitoring canary and production.

* [Following Service Grafana](https://grafana.xarth.tv/dashboard/db/following-service?refresh=1m&orgId=1)
* [Production Rollbar](https://rollbar.com/Twitch/Following/). Spot check for new errors on Rollbar (May need to request access in #rollbar)

## Terminology

* [Skadi](https://git.xarth.tv/dta/skadi) - in-house service that powers clean-deploy and coordinates deployments
* [Jenkins](https://jenkins-og.xarth.tv/job/feeds-following-service/) - automation server that creates builds, runs tests, and triggers deploys
* [Chasqui](https://docs.google.com/document/d/1dKs8EEbzeyFk3bVepe9WjeQx9JZWYDZE75IB5ZFMxZY/edit#) - lambda that triggers CodeDeploy executions
* [CodeDeploy](https://us-west-2.console.aws.amazon.com/codesuite/codedeploy/applications/following-service?region=us-west-2) - executes deployments
* [Puppet](https://git.xarth.tv/systems/puppet) - Twitch configuration management for servers

## What happens when clicking deploy on clean-deploy

Flow of what happens when deploying on [clean-deploy](https://deploy.xarth.tv/#/feeds/following-service):

1. Skadi triggers Jenkins [feeds-following-service-deploy-chasqui job](https://jenkins-og.xarth.tv/job/feeds-following-service-deploy-chasqui/)
as configured in [deploy.json](https://git.xarth.tv/feeds/following-service/blob/master/deploy.json)
1. The Jenkins job triggers the Chasqui lambda with the git commit sha1 and environment as configured in the
`feeds-following-service-deploy-chasqui` job of [jenkins.groovy](https://git.xarth.tv/feeds/following-service/blob/master/jenkins.groovy)
1. The Chasqui lambda triggers a CodeDeploy execution for the relevant environment and git commit SHA based on the
 [chasqui.yml](https://git.xarth.tv/feeds/following-service/blob/master/chasqui.yml)
1. CodeDeploy runs through various [deployment steps](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#reference-appspec-file-structure-hooks-list)
 for each instance in each Auto Scaling Group associated with the deployment group one at a time and runs the scripts
 detailed in [appspec.yml](https://git.xarth.tv/feeds/following-service/blob/master/appspec.yml)
 at each step:
   1. **ApplicationStop**
      1. For API instances, runs [deregister_from_elb.sh](https://git.xarth.tv/feeds/following-service/blob/master/codedeploy/deregister_from_elb.sh)
      ([source](https://github.com/aws-samples/aws-codedeploy-samples/tree/master/load-balancing/elb)) to remove the instance
      from the ELB, redirecting traffic away from the host
      1. Runs [application_stop.sh](https://git.xarth.tv/feeds/following-service/blob/master/codedeploy/application_stop.sh)
      which triggers the daemon to stop running the process
   1. **Install** - Moves the artifact from the temporary folder into the final destination folder.
   1. **AfterInstall** - Runs [after_install.sh](https://git.xarth.tv/feeds/following-service/blob/master/codedeploy/after_install.sh)
   1. **ApplicationStart** - Runs [application_start.sh](https://git.xarth.tv/feeds/following-service/blob/master/codedeploy/application_start.sh)
   1. **ValidateService**
      1. Runs [validate_service.sh](https://git.xarth.tv/feeds/following-service/blob/master/codedeploy/validate_service.sh)
      which verifies the instances are running by checking for the process and hitting the healthcheck endpoint
      1. Runs [register_with_elb.sh](https://git.xarth.tv/feeds/following-service/blob/master/codedeploy/register_with_elb.sh)
      ([source](https://github.com/aws-samples/aws-codedeploy-samples/tree/master/load-balancing/elb)) to add the instance
      to the ELB
1. If deployments to all hosts succeed, then the deployment succeeds.

## Auto Scaling

Instances currently only autoscale on CPU usage
