freeStyleJob('feeds-following-service') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'feeds/following-service', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell 'manta -v -f build.json'
    saveDeployArtifact 'feeds/following-service', '.manta'
    saveChasquiArtifact 'following-service', '.manta', 'deployments-following-service', '914569885343'
    //saveChasquiArtifact 'following-service', '.manta', 'deployments-following-service', '724951484461'
  }
}

freeStyleJob('feeds-following-service-coverage') {
  using 'TEMPLATE-autobuild'

  scm {
    git {
      remote {
        github 'feeds/following-service', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    environmentVariables {
      env('GIT_BRANCH', '${GIT_BRANCH}')
      env('GIT_COMMIT', '${GIT_COMMIT}')
      env('GIT_URL', '${GIT_URL}')
    }
  }

  steps {
    shell 'manta -v -f .manta-coverage.json'
  }

  publishers {
    reportQuality('feeds/following-service', '.manta')
  }
}

freeStyleJob('feeds-following-service-deploy') {
  using 'TEMPLATE-deploy-aws'
  steps {
    shell 'courier deploy --repo feeds/following-service --dir /opt/twitch/following-service'
  }
}
 
freeStyleJob('feeds-following-service-deploy-chasqui') {
  using 'TEMPLATE-deploy-aws-chasqui'
  steps {
    deployChasquiArtifact 'following-service', '\$ENVIRONMENT', 'deployments-following-service'
  }
}
