package followsrpcserver

import (
	"fmt"
	"sync"

	"context"

	pb "code.justin.tv/feeds/following-service/rpc/followsrpc"
	"github.com/twitchtv/twirp"
)

func (s *Server) BatchCountFollowers(ctx context.Context, req *pb.UserIDsReq) (*pb.BatchCountsResp, error) {
	userIDs := req.UserIds
	followersCountMap := make(map[string]int, len(userIDs))
	if len(userIDs) > 100 {
		return nil, twirp.InvalidArgumentError("users_ids", fmt.Sprintf("expected req length to not exceed 100, got %d", len(userIDs)))
	}

	var err error
	var mutex sync.Mutex
	var wg sync.WaitGroup

	wg.Add(len(userIDs))
	for _, userID := range userIDs {
		go func(userID string) {
			defer wg.Done()
			followersCount, cErr := s.Backend.CountFollowers(ctx, userID)
			mutex.Lock()
			defer mutex.Unlock()
			followersCountMap[userID] = followersCount
			if cErr != nil {
				err = cErr
			}
		}(userID)
	}
	wg.Wait()
	if err != nil {
		return nil, err
	}

	counts := make([]*pb.BatchCountResp, 0, len(userIDs))
	for _, userID := range userIDs {
		if resp, ok := followersCountMap[userID]; ok {
			count := &pb.BatchCountResp{
				Count:  int32(resp),
				UserId: userID,
			}
			counts = append(counts, count)
		}
	}
	return &pb.BatchCountsResp{
		Counts: counts,
	}, nil
}
