package followsrpcserver_test

import (
	"context"
	"errors"

	"code.justin.tv/feeds/following-service/rpc/followsrpc"
	"github.com/stretchr/testify/mock"
)

func (s *FollowsSuite) TestBatchCountFollowersSuccess() {
	s.backendMock.On("CountFollowers", mock.Anything, "1").Return(11, nil)
	s.backendMock.On("CountFollowers", mock.Anything, "2").Return(22, nil)
	s.backendMock.On("CountFollowers", mock.Anything, "3").Return(33, nil)
	resp, err := s.followsService.BatchCountFollowers(context.Background(), &followsrpc.UserIDsReq{
		UserIds: []string{"1", "2", "3"},
	})

	s.backendMock.AssertExpectations(s.T())
	s.Assert().NoError(err)
	s.Assert().Equal(int32(11), resp.Counts[0].Count, "expect response count to be 11")
	s.Assert().Equal(int32(22), resp.Counts[1].Count, "expect response count to be 22")
	s.Assert().Equal(int32(33), resp.Counts[2].Count, "expect response count to be 33")
}

func (s *FollowsSuite) TestBatchCountFollowersOneError() {
	s.backendMock.On("CountFollowers", mock.Anything, "1").Return(11, nil)
	s.backendMock.On("CountFollowers", mock.Anything, "2").Return(22, nil)
	s.backendMock.On("CountFollowers", mock.Anything, "3").Return(0, errors.New("trololol"))
	resp, err := s.followsService.BatchCountFollowers(context.Background(), &followsrpc.UserIDsReq{
		UserIds: []string{"1", "2", "3"},
	})

	s.backendMock.AssertExpectations(s.T())
	s.Assert().Nil(resp)
	s.Assert().EqualError(err, "trololol")
}
