package followsrpcserver

import (
	"context"
	"strings"

	"code.justin.tv/feeds/following-service/backend"

	pb "code.justin.tv/feeds/following-service/rpc/followsrpc"

	"github.com/twitchtv/twirp"
)

func (s *Server) BatchHideFollows(ctx context.Context, req *pb.BatchUpdateReq) (*pb.BatchUpdateResp, error) {
	return s.batchUpdate(ctx, req, backend.FollowsKind, backend.HiddenFollowsKind)
}

func (s *Server) BatchHideFollowers(ctx context.Context, req *pb.BatchUpdateReq) (*pb.BatchUpdateResp, error) {
	return s.batchUpdate(ctx, req, backend.FollowersKind, backend.HiddenFollowersKind)
}

func (s *Server) BatchRestoreFollows(ctx context.Context, req *pb.BatchUpdateReq) (*pb.BatchUpdateResp, error) {
	return s.batchUpdate(ctx, req, backend.HiddenFollowsKind, backend.FollowsKind)
}

func (s *Server) BatchRestoreFollowers(ctx context.Context, req *pb.BatchUpdateReq) (*pb.BatchUpdateResp, error) {
	return s.batchUpdate(ctx, req, backend.HiddenFollowersKind, backend.FollowersKind)
}

func (s *Server) BatchDeleteFollows(ctx context.Context, req *pb.BatchUpdateReq) (*pb.BatchUpdateResp, error) {
	return s.batchDelete(ctx, req, backend.FollowsKind)
}

func (s *Server) BatchDeleteFollowers(ctx context.Context, req *pb.BatchUpdateReq) (*pb.BatchUpdateResp, error) {
	return s.batchDelete(ctx, req, backend.FollowersKind)
}

func (s *Server) batchUpdate(ctx context.Context, req *pb.BatchUpdateReq, edge, newEdge string) (*pb.BatchUpdateResp, error) {
	req.UserId = strings.TrimSpace(req.UserId)
	if req.UserId == "" {
		return nil, twirp.RequiredArgumentError("user_id")
	}

	more, err := s.Backend.BulkUpdateFollows(ctx, req.UserId, int(req.Limit), edge, newEdge)
	if err != nil {
		return nil, twirp.InternalErrorWith(err)
	}
	return &pb.BatchUpdateResp{More: more}, nil
}

func (s *Server) batchDelete(ctx context.Context, req *pb.BatchUpdateReq, edge string) (*pb.BatchUpdateResp, error) {
	req.UserId = strings.TrimSpace(req.UserId)
	if req.UserId == "" {
		return nil, twirp.RequiredArgumentError("user_id")
	}

	more, err := s.Backend.BulkDeleteFollows(ctx, req.UserId, int(req.Limit), edge)
	if err != nil {
		return nil, twirp.InternalErrorWith(err)
	}
	return &pb.BatchUpdateResp{More: more}, nil
}
