package followsrpcserver

import (
	"strings"

	"context"

	pb "code.justin.tv/feeds/following-service/rpc/followsrpc"
	"github.com/twitchtv/twirp"
)

// CountFollowers counts the followers of user_id
func (s *Server) CountFollowers(ctx context.Context, req *pb.UserIDReq) (*pb.CountResp, error) {
	req.UserId = strings.TrimSpace(req.UserId)

	// validate
	if req.UserId == "" {
		return nil, twirp.RequiredArgumentError("user_id")
	}

	// count on backend
	// Note: if user does not exist, it just returns 0 count (no error).
	count, err := s.Backend.CountFollowers(ctx, req.UserId)
	if err != nil {
		return nil, twirp.InternalErrorWith(err)
	}

	// Cache-Control header, used by Visage's cache mechanism
	err = twirp.SetHTTPResponseHeader(ctx, "Cache-Control", "public, max-age=60")
	if err != nil {
		return nil, twirp.InternalErrorWith(err)
	}

	return &pb.CountResp{
		Count: int32(count),
	}, nil
}
