package followsrpcserver

import (
	"strings"

	"context"

	pb "code.justin.tv/feeds/following-service/rpc/followsrpc"
	"github.com/twitchtv/twirp"
)

// CountFollows counts users followed by user_id
func (s *Server) CountFollows(ctx context.Context, req *pb.UserIDReq) (*pb.CountResp, error) {
	req.UserId = strings.TrimSpace(req.UserId)
	if req.UserId == "" {
		return nil, twirp.RequiredArgumentError("user_id")
	}

	count, err := s.Backend.CountFollows(ctx, req.UserId)
	if err != nil {
		return nil, twirp.InternalErrorWith(err)
	}

	err = twirp.SetHTTPResponseHeader(ctx, "Cache-Control", "public, max-age=60")
	if err != nil {
		return nil, twirp.InternalErrorWith(err)
	}
	return &pb.CountResp{
		Count: int32(count),
	}, nil
}
