package followsrpcserver

import (
	"log"
	"strings"
	"time"

	"context"

	pb "code.justin.tv/feeds/following-service/rpc/followsrpc"
	"github.com/golang/protobuf/ptypes/empty"
	"github.com/twitchtv/twirp"
)

// DeleteAllFollows hides all followers and follows related to a user
func (s *Server) DeleteAllFollows(ctx context.Context, req *pb.UserIDReq) (*empty.Empty, error) {
	req.UserId = strings.TrimSpace(req.UserId)

	// validate
	if req.UserId == "" {
		return nil, twirp.RequiredArgumentError("user_id")
	}

	go func() {
		// 4hr is the same as GraphDB internal timeout for delete jobs
		reqCtx, cancel := context.WithTimeout(context.Background(), 4*time.Hour)
		defer cancel()
		if err := s.Backend.DestroyUser(reqCtx, req.UserId); err != nil {
			sErr := s.Stats.Inc("backendv2.destroy_user.err", 1, 1.0)
			if sErr != nil {
				log.Print(err)
			}
		}
	}()

	// Cache-Control header, used by Visage's cache mechanism
	err := twirp.SetHTTPResponseHeader(ctx, "Cache-Control", "public, max-age=60")
	if err != nil {
		return nil, twirp.InternalErrorWith(err)
	}

	return &empty.Empty{}, nil
}
