package followsrpcserver_test

import (
	"context"
	"time"

	"github.com/stretchr/testify/mock"

	"code.justin.tv/feeds/following-service/rpc/followsrpc"
)

func (s *FollowsSuite) TestDeleteAllFollowsSuccess() {
	s.backendMock.On("DestroyUser", mock.Anything, "1").Return(nil)
	err := s.DoDeleteAllFollows("1")
	time.Sleep(200 * time.Millisecond)

	s.backendMock.AssertExpectations(s.T())
	s.Assert().NoError(err)
}

func (s *FollowsSuite) TestDeleteAllFollowsEmptyUserIDError() {
	err := s.DoDeleteAllFollows("")

	s.backendMock.AssertNotCalled(s.T(), "DeleteAllFollows") // validation fails even before making a backend request
	s.Assert().EqualError(err, "twirp error invalid_argument: user_id is required")
}

// Helpers

func (s *FollowsSuite) DoDeleteAllFollows(userID string) error {
	req := &followsrpc.UserIDReq{UserId: userID}
	_, err := s.followsService.DeleteAllFollows(context.Background(), req)
	return err
}
