package followsrpcserver

import (
	"strings"

	"context"

	pb "code.justin.tv/feeds/following-service/rpc/followsrpc"
	"github.com/golang/protobuf/ptypes/empty"
	"github.com/twitchtv/twirp"
)

// HideAllFollows hides all followers and follows related to a user
func (s *Server) HideAllFollows(ctx context.Context, req *pb.UserIDReq) (*empty.Empty, error) {
	req.UserId = strings.TrimSpace(req.UserId)

	// validate
	if req.UserId == "" {
		return nil, twirp.RequiredArgumentError("user_id")
	}

	err := s.Backend.HideAllFollows(ctx, req.UserId)
	if err != nil {
		return nil, twirp.InternalErrorWith(err)
	}

	// Cache-Control header, used by Visage's cache mechanism
	err = twirp.SetHTTPResponseHeader(ctx, "Cache-Control", "public, max-age=60")
	if err != nil {
		return nil, twirp.InternalErrorWith(err)
	}

	return &empty.Empty{}, nil
}
