package followsrpcserver_test

import (
	"errors"

	"context"

	"github.com/stretchr/testify/mock"

	"code.justin.tv/feeds/following-service/rpc/followsrpc"
)

func (s *FollowsSuite) TestHideAllFollowsSuccess() {
	s.backendMock.On("HideAllFollows", mock.Anything, "1").Return(nil)
	err := s.DoHideAllFollows("1")
	s.backendMock.AssertExpectations(s.T())
	s.Assert().NoError(err)
}

func (s *FollowsSuite) TestHideAllFollowsBackendServerError() {
	s.backendMock.On("HideAllFollows", mock.Anything, "1").
		Return(errors.New("trololol")) // oops, something went wrong

	err := s.DoHideAllFollows("1")

	s.backendMock.AssertExpectations(s.T())
	s.Assert().EqualError(err, "twirp error internal: trololol")
}

func (s *FollowsSuite) TestHideAllFollowsEmptyUserIDError() {
	err := s.DoHideAllFollows("")

	s.backendMock.AssertNotCalled(s.T(), "HideAllFollows") // validation fails even before making a backend request
	s.Assert().EqualError(err, "twirp error invalid_argument: user_id is required")
}

// Helpers

func (s *FollowsSuite) DoHideAllFollows(userID string) error {
	req := &followsrpc.UserIDReq{UserId: userID}
	_, err := s.followsService.HideAllFollows(context.Background(), req)
	return err
}
