package followsrpcserver_test

import (
	"errors"

	"context"

	"github.com/stretchr/testify/mock"

	"code.justin.tv/feeds/following-service/rpc/followsrpc"
)

func (s *FollowsSuite) TestRestoreAllFollowsSuccess() {
	s.backendMock.On("RestoreAllFollows", mock.Anything, "1").Return(nil)

	err := s.DoRestoreAllFollows("1")

	s.backendMock.AssertExpectations(s.T())
	s.Assert().NoError(err)
}

func (s *FollowsSuite) TestRestoreAllFollowsBackendServerError() {
	s.backendMock.On("RestoreAllFollows", mock.Anything, "1").
		Return(errors.New("trololol")) // oops, something went wrong

	err := s.DoRestoreAllFollows("1")

	s.backendMock.AssertExpectations(s.T())
	s.Assert().EqualError(err, "twirp error internal: trololol")
}

func (s *FollowsSuite) TestRestoreAllFollowsEmptyUserIDError() {
	err := s.DoRestoreAllFollows("")

	s.backendMock.AssertNotCalled(s.T(), "RestoreAllFollows") // validation fails even before making a backend request
	s.Assert().EqualError(err, "twirp error invalid_argument: user_id is required")
}

// Helpers

func (s *FollowsSuite) DoRestoreAllFollows(userID string) error {
	req := &followsrpc.UserIDReq{UserId: userID}
	_, err := s.followsService.RestoreAllFollows(context.Background(), req)
	return err
}
