data "terraform_remote_state" "account" {
  backend = "s3"

  config = {
    bucket  = "${lookup(var.account, var.environment)}"
    region  = "us-west-2"
    key     = "tfstate/feeds/terraform/accounts/${lookup(var.account, var.environment)}"
    profile = "${lookup(var.account, var.environment)}"
  }
}

data "terraform_remote_state" "asg_lambda" {
  backend = "s3"

  config = {
    bucket  = "${lookup(var.account, var.environment)}"
    region  = "us-west-2"
    key     = "tfstate/feeds/asg-r53-lambda/services/lambda/${lookup(var.account, var.environment)}"
    profile = "${lookup(var.account, var.environment)}"
  }
}
