resource "aws_sns_topic" "new_follower_topic" {
  name = "${replace(var.name, "-", "_")}_${var.environment}_followercreated_notifications"

  lifecycle {
    prevent_destroy = true
  }
}

resource "aws_sns_topic" "update_follow_topic" {
  name = "${var.name}_${var.environment}_updatefollow_notifications"

  lifecycle {
    prevent_destroy = true
  }
}

# This policy defines the AWS accounts that may subscribe to this topic.
data "aws_iam_policy_document" "new_follower_topic_role_policy" {
  statement {
    sid = "AllowSubscriptionsFromOtherTwitchAWSAccounts"

    principals {
      type        = "AWS"
      identifiers = "${var.follow_topic_can_subscribe_accounts}"
    }

    actions = [
      "SNS:Subscribe",
      "SNS:Receive",
      "SNS:ListSubscriptionsByTopic",
    ]

    resources = [
      "${aws_sns_topic.new_follower_topic.arn}",
    ]
  }
}

resource "aws_sns_topic_policy" "new_follower_topic_policy" {
  arn    = "${aws_sns_topic.new_follower_topic.arn}"
  policy = "${data.aws_iam_policy_document.new_follower_topic_role_policy.json}"
}

# This policy defines the AWS accounts that may subscribe to this topic.
data "aws_iam_policy_document" "update_follow_topic_role_policy" {
  statement {
    sid = "AllowSubscriptionsFromOtherTwitchAWSAccounts"

    principals {
      type        = "AWS"
      identifiers = "${var.follow_topic_can_subscribe_accounts}"
    }

    actions = [
      "SNS:Subscribe",
      "SNS:Receive",
      "SNS:ListSubscriptionsByTopic",
    ]

    resources = [
      "${aws_sns_topic.update_follow_topic.arn}",
    ]
  }

  statement {
    sid = "AllowSubscriptionsFromOtherTwitchAWSAccountsToPublish"

    principals {
      type        = "AWS"
      identifiers = "${var.follow_topic_can_publish_accounts}"
    }

    actions = [
      "SNS:Publish",
    ]

    resources = [
      "${aws_sns_topic.update_follow_topic.arn}",
    ]
  }
}

resource "aws_sns_topic_policy" "update_follow_topic_policy" {
  arn    = "${aws_sns_topic.update_follow_topic.arn}"
  policy = "${data.aws_iam_policy_document.update_follow_topic_role_policy.json}"
}
