# Service name used for AWS tagging among other things
variable "name" {}

# DNS safe service name
variable "hostname" {}

# Domain
variable "domain" {
  default = {
    "production" = "prod.us-west2.justin.tv"
    "staging"    = "dev.us-west2.justin.tv"
  }

  type = "map"
}

variable "cache_availability_zones" {
  type        = "list"
  description = "Note: Change this if you change the region we have the service in"
}

# AWS Account
variable "account" {
  default = {
    "production" = "twitch-feed-aws"
    "staging"    = "twitch-feed-dev"
  }

  type = "map"
}

# Team email alias
variable "owner" {}

# Project name, usually git repo. ex. dta/twitch-create-service
variable "project" {}

# EC2 Instance Image
variable "ami" {
  default = "ami-dd11f3bd"
}

# X-Ray Role
variable "xray_role" {}

# EC2 Instance Type
variable "instance_type" {
  default = "c4.large"
}

# Largest a service cluster will grow to
variable "max_size" {
  default = 0
}

# Smallest a service cluster will shrink down to
variable "min_size" {
  default = 0
}

# Number of canary instances
variable "canary_size" {
  default = 0
}

# Service environment
variable "environment" {}

# Amount of diskspace allocated to the root drive. (GB)
variable "root_volume_size" {
  default = 256
}

# Service role for controlling access to other AWS services
variable "iam_role_name" {
  default = "following-service"
}

# Service name
variable "service_name" {
  default = "following-service"
}

# Team
variable "team" {
  default = "feeds"
}

variable "follow_topic_can_subscribe_accounts" {
  description = "Accounts that can subscribe to the follow topics"
  type        = "list"
}

variable "follow_topic_can_publish_accounts" {
  description = "Accounts that can publish to the follow topics"
  type        = "list"
}

variable "sandstorm_role_arn" {}

variable "eventbus_publish_arn_pattern" {
  default = "arn:aws:sns:us-west-2:859517684765:eventbus_*"
}