variable "app_name" {
  type = string
  description = "Application name to create the PrivateLink setup."
}
variable "environment" {
  type        = "string"
  description = "Environment PrivateLink setup is for."
}
variable "internal_alb_dns_name" {
  type        = "string"
  description = "DNS name for the load balancer."
}
variable "vpc" {
  type        = "string"
  description = "VPC the PrivateLink should be setup."
}
variable "aws_region" {
  type        = "string"
  default     = "us-west-2"
  description = "AWS region the PrivateLink should be setup."
}
variable "account_id" {
  type        = "string"
  description = "AWS account the PrivateLink should be setup."
}
variable "subnet_a" {
  type        = "string"
  description = "First subnet the PrivateLink should be setup"
}
variable "subnet_b" {
  type        = "string"
  description = "Second subnet the PrivateLink should be setup"
}
variable "subnet_c" {
  type        = "string"
  description = "Third subnet the PrivateLink should be setup"
}
variable "allowed_principals" {
  type        = "list"
  description = "The account IDs that are whitelisted for this endpoint service"
}

resource "aws_lb" "pl_nlb" {
  name                             = "${var.app_name}-${var.environment}-PLELB"
  internal                         = true
  load_balancer_type               = "network"
  enable_cross_zone_load_balancing = true

  subnets = [
    "${var.subnet_a}",
    "${var.subnet_b}",
    "${var.subnet_c}",
  ]
}

resource "aws_vpc_endpoint_service" "vpc_endpoint_service" {
  acceptance_required        = false
  network_load_balancer_arns = ["${aws_lb.pl_nlb.arn}"]

  allowed_principals = "${var.allowed_principals}"

  tags = {
    "Name": "${var.app_name}-${var.environment}"
  }
}
