resource "aws_vpc_endpoint" "service" {
  vpc_id              = var.vpc_id
  vpc_endpoint_type   = "Interface"
  service_name        = var.service_name
  subnet_ids          = var.private_subnets
  security_group_ids  = var.security_groups
  private_dns_enabled = var.private_dns_enabled

  tags = {
    Name = var.name
  }
}

resource "aws_route53_zone" "vpc_endpoint_dns_zone" {
  name = var.ssl_domain_name

  vpc {
    vpc_id = var.vpc_id
  }

  count = var.ssl_domain_name != "" ? 1 : 0
}

resource "aws_route53_record" "vpc_endpoint_dns_record" {
  zone_id = aws_route53_zone.vpc_endpoint_dns_zone[count.index].zone_id
  name    = aws_route53_zone.vpc_endpoint_dns_zone[count.index].name
  type    = "A"

  alias {
    name                   = aws_vpc_endpoint.service.dns_entry.0.dns_name
    zone_id                = aws_vpc_endpoint.service.dns_entry.0.hosted_zone_id
    evaluate_target_health = false
  }

  count = var.ssl_domain_name != "" ? 1 : 0
}
