variable "name" {
  type        = string
  description = "Service name to identify/tag this resource by"
}

variable "vpc_id" {
  type        = string
  description = "The VPC in which VPC endpoints should be created in"
}

variable "private_subnets" {
  type        = list(string)
  description = "The subnets in the VPC that VPC endpoints should be created in"
}

variable "security_groups" {
  type        = list(string)
  description = "The security groups of the subnets in the VPC that VPC endpoints should be created in"
}

variable "service_name" {
  type        = string
  description = "VPC Endpoint Service mame"
}

variable "ssl_domain_name" {
  type        = string
  default     = ""
  description = "the dns name to create a route53 entry for"
}

variable "private_dns_enabled" {
  type        = bool
  default     = false
  description = "whether this vpce will utilize private dns"
}