terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "tfstate/feeds/following-service/terraform/production"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

locals {
  vpc_id             = "vpc-29b8fe4d"
  private_subnet_ids = ["subnet-e588ff81", "subnet-814ac4f7", "subnet-118b5d49"]
  security_groups    = ["sg-5c05723a"]
}

module "following-service" {
  source             = "../modules/following-service"
  name               = "following-service"
  hostname           = "following-service"
  owner              = "marcgunn@twitch.tv"
  project            = "feeds/following-service"
  ami                = "ami-06a9cefef11216c98"
  instance_type      = "c4.4xlarge"
  max_size           = 0
  min_size           = 0
  canary_size        = 0
  environment        = "production"
  root_volume_size   = "256"
  iam_role_name      = "following-service"
  sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
  xray_role          = "arn:aws:iam::641044725657:role/foundation-xray-role"

  // The len of the list must equal the number of nodes: see
  // http://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheCluster.html and
  // PreferredAvailabilityZones.PreferredAvailabilityZone.N
  // We can use > 3 nodes of smaller types when https://github.com/terraform-providers/terraform-provider-aws/issues/2658 is resolved

  cache_availability_zones = ["us-west-2a", "us-west-2b", "us-west-2c"]

  follow_topic_can_subscribe_accounts = [
    "arn:aws:iam::989470033077:root", # creator-business
    "arn:aws:iam::641044725657:root", # twitch-web-aws
    "arn:aws:iam::465369119046:root", # twitch-web-dev
    "arn:aws:iam::663583029956:root", # twitch-edge-aws
    "arn:aws:iam::435147058744:root", # twitch-edge-dev
    "arn:aws:iam::924637445623:root", # twitch-discovery-aws
    "arn:aws:iam::471167244615:root", # twitch-copo-prod
    "arn:aws:iam::449373877825:root", # twitch-kirby-prod
  ]

  follow_topic_can_publish_accounts = [
    "arn:aws:iam::323239328689:root", # twitch-vx-lit+followingservice-prod-us-west-2
  ]
}

module "privatelink" {
  source = "../modules/privatelink"

  aws_region            = "us-west-2"
  account_id            = "914569885343"
  app_name              = "followsrpc"
  environment           = "production"
  internal_alb_dns_name = "internal-following-service-production-app-772191406.us-west-2.elb.amazonaws.com"
  allowed_principals = [
    "arn:aws:iam::028439334451:root", # Helix prod
    "arn:aws:iam::471167244615:root",
    "arn:aws:iam::848870997264:root",
    "arn:aws:iam::961173973684:root", # twitch-subs-rec-prod@amazon.com
    "arn:aws:iam::925593871070:root", # following-prod-us-west-2
    "arn:aws:iam::625711050187:root", # twitch-navi-prod-us-west-2
    "arn:aws:iam::940853426594:root", # voyager-prod-us-west-2
    "arn:aws:iam::725151454759:root", # twitch-forage-prod
    "arn:aws:iam::628947764166:root", # clipfinity-prod-us-west-2
    "arn:aws:iam::449373877825:root", # twitch-kirby-prod
    "arn:aws:iam::196915980276:root", # twitch-admin-panel-aws
    "arn:aws:iam::948329120781:root", # twitch-clips-aws
    "arn:aws:iam::193757392363:root", # twitch-gta-prod
    "arn:aws:iam::947153321414:root", # TwitchRaids-us-west-2
  ]
  vpc      = local.vpc_id
  subnet_a = local.private_subnet_ids[0]
  subnet_b = local.private_subnet_ids[1]
  subnet_c = local.private_subnet_ids[2]
}

module "dart_receiver" {
  source = "../modules/vpc_endpoints"

  name            = "dart_receiver"
  service_name    = "com.amazonaws.vpce.us-west-2.vpce-svc-04bef8bdac64fa932"
  ssl_domain_name = "production.receiver.twitch.a2z.com"
  vpc_id          = local.vpc_id
  private_subnets = local.private_subnet_ids
  security_groups = local.security_groups
}

module "follow_bot_detection" {
  source = "../modules/vpc_endpoints"

  name                = "follow_bot_detection"
  service_name        = "com.amazonaws.vpce.us-west-2.vpce-svc-0e6e08f217d7fa97f"
  vpc_id              = local.vpc_id
  private_subnets     = local.private_subnet_ids
  security_groups     = local.security_groups
  private_dns_enabled = true
}

module "graphdb_fulton" {
  source = "../modules/vpc_endpoints"

  name                = "graphdb_fulton"
  service_name        = "com.amazonaws.vpce.us-west-2.vpce-svc-072153a03ee6641be"
  ssl_domain_name     = "us-west-2.prod.twitchvxgraphdbecs.s.twitch.a2z.com"
  vpc_id              = local.vpc_id
  private_subnets     = local.private_subnet_ids
  security_groups     = local.security_groups
}
