terraform {
  backend "s3" {
    bucket  = "twitch-feed-dev"
    key     = "tfstate/feeds/following-service/terraform/staging"
    region  = "us-west-2"
    profile = "twitch-feed-dev"
  }
}

locals {
  vpc_id             = "vpc-5bb8fe3f"
  private_subnet_ids = ["subnet-9f4ac4e9", "subnet-0b88ff6f", "subnet-658b5d3d"]
  security_groups    = ["sg-71057217"]
}

module "following-service" {
  source             = "../modules/following-service"
  name               = "following-service"
  hostname           = "following-service"
  owner              = "marcgunn@twitch.tv"
  project            = "feeds/following-service"
  ami                = "ami-0ba0e619a4c58734d"
  instance_type      = "c4.4xlarge"
  min_size           = 0
  max_size           = 0
  canary_size        = 0
  environment        = "staging"
  root_volume_size   = "256"
  iam_role_name      = "following-service"
  sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-staging"
  xray_role          = "arn:aws:iam::465369119046:role/foundation-xray-role"

  // The len of the list must equal the number of nodes: see
  // http://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheCluster.html and
  // PreferredAvailabilityZones.PreferredAvailabilityZone.N

  cache_availability_zones = ["us-west-2a", "us-west-2b"]

  follow_topic_can_subscribe_accounts = [
    "arn:aws:iam::989470033077:root", # creator-business
    "arn:aws:iam::465369119046:root", # twitch-web-dev
    "arn:aws:iam::924637445623:root", # twitch-discovery-aws
    "arn:aws:iam::962912953676:root", # twitch-copo-dev
    "arn:aws:iam::178482276949:root", # twitch-kirby-dev
  ]

  follow_topic_can_publish_accounts = [
    "arn:aws:iam::958394070436:root", # twitch-vx-lit+followingservice-beta-us-west-2
  ]
}

module "privatelink" {
  source = "../modules/privatelink"

  aws_region            = "us-west-2"
  account_id            = "724951484461"
  app_name              = "followsrpc"
  environment           = "staging"
  internal_alb_dns_name = "internal-following-service-staging-app-2022864404.us-west-2.elb.amazonaws.com"
  allowed_principals = [
    "arn:aws:iam::327140220177:root", # Helix staging
    "arn:aws:iam::962912953676:root",
    "arn:aws:iam::509742390962:root", # following-beta-us-west-2
    "arn:aws:iam::229120731648:root", # twitch-navi-beta-us-west-2
    "arn:aws:iam::411162717697:root", # voyager-beta-us-west-2
    "arn:aws:iam::780445362494:root", # twitch-forage-dev
    "arn:aws:iam::820618247435:root", # clipfinity-beta-us-west-2
    "arn:aws:iam::848870997264:root", # twitch-subs-rec-dev@amazon.com
    "arn:aws:iam::178482276949:root", # twitch-kirby-dev
    "arn:aws:iam::219087926005:root", # twitch-admin-panel-dev
    "arn:aws:iam::948329120781:root", # twitch-clips-aws
    "arn:aws:iam::489082260240:root", # twitch-gta-dev
    "arn:aws:iam::841118063981:root", # TwitchRaids-beta-us-west-2
  ]
  vpc      = local.vpc_id
  subnet_a = local.private_subnet_ids[0]
  subnet_b = local.private_subnet_ids[1]
  subnet_c = local.private_subnet_ids[2]
}

module "dart_receiver" {
  source = "../modules/vpc_endpoints"

  name            = "dart_receiver"
  service_name    = "com.amazonaws.vpce.us-west-2.vpce-svc-0796a8b920e1d6946"
  ssl_domain_name = "staging.receiver.twitch.a2z.com"
  vpc_id          = local.vpc_id
  private_subnets = local.private_subnet_ids
  security_groups = local.security_groups
}

module "graphdb_fulton" {
  source = "../modules/vpc_endpoints"

  name                = "graphdb_fulton"
  service_name        = "com.amazonaws.vpce.us-west-2.vpce-svc-02f05069eb2b4da54"
  ssl_domain_name     = "us-west-2.beta.twitchvxgraphdbecs.s.twitch.a2z.com"
  vpc_id              = local.vpc_id
  private_subnets     = local.private_subnet_ids
  security_groups     = local.security_groups
}
