package zuma

import (
	"bytes"
	"encoding/json"

	"context"

	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/foundation/twitchclient"
)

func (c *client) GetInboxDownloadLink(ctx context.Context, params api.GetInboxDownloadLinkRequest, reqOpts *twitchclient.ReqOpts) (api.GetInboxDownloadLinkResponse, error) {
	bodyBytes, err := json.Marshal(params)
	if err != nil {
		return api.GetInboxDownloadLinkResponse{}, err
	}

	req, err := c.NewRequest("POST", "/v1/users/inbox/get_download_link", bytes.NewReader(bodyBytes))
	if err != nil {
		return api.GetInboxDownloadLinkResponse{}, err
	}

	combinedReqOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.zuma.inbox.download_inbox_link",
		StatSampleRate: defaultStatSampleRate,
	})

	var decoded api.GetInboxDownloadLinkResponse
	if _, err := c.DoJSON(ctx, &decoded, req, combinedReqOpts); err != nil {
		return api.GetInboxDownloadLinkResponse{}, err
	}

	return decoded, nil
}
