# DEPRECATED

**Twitchhttp has been deprecated and will no longer be actively maintained. Please use the new projects under the
Foundation Engineering organization**

- **[Twitch Server](https://git-aws.internal.justin.tv/foundation/twitchserver)**
- **[Twitch Client](https://git-aws.internal.justin.tv/foundation/twitchclient)**

The 1.0.0 releases for both repositories are backwards compatible with common/twitchhttp.


# twitchhttp

[![GoDoc](http://godoc.internal.justin.tv/code.justin.tv/common/twitchhttp?status.svg)](http://godoc.internal.justin.tv/code.justin.tv/common/twitchhttp)

Package twitchhttp enables quicker creation of production-ready HTTP clients and servers.

## Clients

Clients are pre-configured with a [Chitin](https://git-aws.internal.justin.tv/common/chitin) RoundTripper and some extra features to handle authentication and other common parameters.

You can make a pre-configured `http.Client` with `twitchhttp.NewHTTPClient(conf)`. You can use the `http.Client` to interact cleanly with twitchhttp-agnostic libraries (like Twirp) while also gaining the benefits of a standard `twitchhttp.Client`.

Alternatively, you can make a specific `twitchhttp.Client` with `twitchhttp.NewClient(conf)`, which has it's own interface and can not be used as `http.Client` in twitchhttp-agnostic libraries, but it has the convenient `DoJSON` method which is useful to simplify JSON requests and responses.

The two constructors are equivalent in terms of functionality: `twitchhttp.Client` was created first, and the compatible `http.Client` was created later to allow visage-twirp integration (see #43).

## Servers

Twitchhttp allows to start http servers with a few features out of the box:

  * pre-configured with [Chitin](https://git-aws.internal.justin.tv/common/chitin)
  * profiling
  * Rollbar integration (intercepts panics)
  * a health check endpoint `/debug/running` for load balancer health checks
  * runtime metrics (through gometrics)
  * graceful shutdowns

### Graceful shutdowns

A twitchhttp server can be configured to shut down gracefully.

AddDefaultSignalHandlers will add default signal handlers for graceful shut down if SIGINT, SIGTERM, or SIGUSR2 are
received by the process.

Additional OS signals added by AddShutdownSignal will result in a graceful shutdown.

For other cases, Shutdown and ShutdownNow methods are provided which shut down gracefully and ungracefully, respectively. A timeout should always be specified when using graceful shutdown so that a server will not permanently hang while shutting down.
