// Code generated by protoc-gen-twirp v5.5.0, DO NOT EDIT.
// source: proto/graphdb.proto

/*
Package graphdb is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.5.0.

It is generated from these files:
	proto/graphdb.proto
*/
package graphdb

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// =================
// GraphDB Interface
// =================

// GraphDB allows creation of nodes and edges inside a generic graph database
type GraphDB interface {
	// EdgeGet returns an association between two entities.  Returns nil if no assoc exists
	// SLO@100ms
	EdgeGet(context.Context, *EdgeGetRequest) (*EdgeGetResponse, error)

	// EdgeCreate creates an association only if one does not exist.  If one did exist, returns nil.
	// SLO@150ms
	EdgeCreate(context.Context, *EdgeCreateRequest) (*EdgeCreateResponse, error)

	// EdgeUpdate updates the values of an association only if does exist.  Returns the new value.
	// If one did not exist or the version did not match, returns nil.
	// version is an optional argument used as an optimistic lock to ensure
	// that no other processes Updated the Edge since it was retrieved.
	// Resolving conflicts is left to the caller.
	// The caller can retry the update operation by re-fetching the item (EdgeGet) to retrieve the new version
	// before calling EdgeUpdate again.
	// SLO@150ms
	EdgeUpdate(context.Context, *EdgeUpdateRequest) (*EdgeUpdateResponse, error)

	// EdgeCount counts the assocs from a source.
	// SLO@100ms
	EdgeCount(context.Context, *EdgeCountRequest) (*EdgeCountResponse, error)

	// EdgeUpdateType changes the type of an assoc
	// SLO@150ms
	EdgeUpdateType(context.Context, *EdgeUpdateTypeRequest) (*EdgeUpdateTypeResponse, error)

	// EdgeDelete removes an association between two entities.
	// Returns the removed entity, otherwise returns nil if it did not exist or if the version did not match.
	// version is an optional argument used as an optimistic lock to ensure
	// that no other processes Updated the Edge since it was retrieved.
	// Resolving conflicts is left to the caller.
	// The caller can retry the delete operation by re-fetching the item (EdgeGet) to retrieve the new version
	// before calling EdgeDelete again.
	// SLO@150ms
	EdgeDelete(context.Context, *EdgeDeleteRequest) (*EdgeDeleteResponse, error)

	// EdgeList lists the assocs from an entity.
	// May consume one read unit, may consume more
	// SLO@200ms
	EdgeList(context.Context, *EdgeListRequest) (*EdgeListResponse, error)

	// EdgeUpdateAllEdgesFromNode allows GraphDB to change *all* edges from a source node to another edge type.  This
	// can sometimes take a very long time for nodes with a large number of edges outside them.
	//
	// This call is async and should return instantly, but will take a long time to finish.
	// SLO@100ms
	EdgeUpdateAllEdgesFromNode(context.Context, *EdgeUpdateAllEdgesFromNodeRequest) (*EdgeUpdateAllEdgesFromNodeResponse, error)

	// BatchEdgeGet returns a list of edges that have an association with each other
	// SLO@300ms
	BatchEdgeGet(context.Context, *BatchEdgeGetRequest) (*BatchEdgeGetResponse, error)

	// BulkEdgeUpdate updates the values of all associations from a source node with a given edge type
	// SLO@300ms
	BulkEdgeUpdate(context.Context, *BulkEdgeUpdateRequest) (*BulkEdgeUpdateResponse, error)

	// BulkEdgeDelete deletes all associations from a source node with a given edge type
	// SLO@300ms
	BulkEdgeDelete(context.Context, *BulkEdgeDeleteRequest) (*BulkEdgeDeleteResponse, error)

	// BulkEdgeUpdateV2 updates the values of all associations from a source node with a given edge type
	// Limit must be <= 2000
	// SLO@60000ms
	BulkEdgeUpdateV2(context.Context, *BulkEdgeUpdateRequestV2) (*BulkEdgeUpdateResponseV2, error)

	// BulkEdgeDeleteV2 deletes all associations from a source node with a given edge type
	// Limit must be <= 2000
	// SLO@60000ms
	BulkEdgeDeleteV2(context.Context, *BulkEdgeDeleteRequestV2) (*BulkEdgeDeleteResponseV2, error)

	// NodeGet returns a node in the graph
	// SLO@100ms
	NodeGet(context.Context, *NodeGetRequest) (*NodeGetResponse, error)

	// NodeCreate creates a node in the graph
	// SLO@150ms
	NodeCreate(context.Context, *NodeCreateRequest) (*NodeCreateResponse, error)

	// NodeUpdate modifies a node that already exists in the graph
	// SLO@150ms
	NodeUpdate(context.Context, *NodeUpdateRequest) (*NodeUpdateResponse, error)

	// NodeCount counts the types of a node
	// SLO@100ms
	NodeCount(context.Context, *NodeCountRequest) (*NodeCountResponse, error)

	// NodeDelete removes a node in the graph.  It will not remove any edges out of the node.
	// SLO@150ms
	NodeDelete(context.Context, *NodeDeleteRequest) (*NodeDeleteResponse, error)

	// NodeList lists all the nodes of a type
	// SLO@250ms
	NodeList(context.Context, *NodeListRequest) (*NodeListResponse, error)

	// Multi is a way to batch multiple requests into a single operation for cohesion.  It won't be more efficient
	// for DynamoDB, but can save trips to graphdb.  There is no guarantee about the order operations are done in.
	//
	// Do *not* send multiple requests that are required to be done in order.
	// SLO@1s
	Multi(context.Context, *MultiRequest) (*MultiResponse, error)

	// MultiAsync sends multiple update requests to execute eventually with a SQS queue.  It is useful for only
	// modification requests, since you can't see the result.
	// SLO@100ms
	MultiAsync(context.Context, *MultiAsyncRequest) (*MultiAsyncResponse, error)
}

// =======================
// GraphDB Protobuf Client
// =======================

type graphDBProtobufClient struct {
	client HTTPClient
	urls   [21]string
}

// NewGraphDBProtobufClient creates a Protobuf client that implements the GraphDB interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewGraphDBProtobufClient(addr string, client HTTPClient) GraphDB {
	prefix := urlBase(addr) + GraphDBPathPrefix
	urls := [21]string{
		prefix + "EdgeGet",
		prefix + "EdgeCreate",
		prefix + "EdgeUpdate",
		prefix + "EdgeCount",
		prefix + "EdgeUpdateType",
		prefix + "EdgeDelete",
		prefix + "EdgeList",
		prefix + "EdgeUpdateAllEdgesFromNode",
		prefix + "BatchEdgeGet",
		prefix + "BulkEdgeUpdate",
		prefix + "BulkEdgeDelete",
		prefix + "BulkEdgeUpdateV2",
		prefix + "BulkEdgeDeleteV2",
		prefix + "NodeGet",
		prefix + "NodeCreate",
		prefix + "NodeUpdate",
		prefix + "NodeCount",
		prefix + "NodeDelete",
		prefix + "NodeList",
		prefix + "Multi",
		prefix + "MultiAsync",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &graphDBProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &graphDBProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *graphDBProtobufClient) EdgeGet(ctx context.Context, in *EdgeGetRequest) (*EdgeGetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeGet")
	out := new(EdgeGetResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) EdgeCreate(ctx context.Context, in *EdgeCreateRequest) (*EdgeCreateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCreate")
	out := new(EdgeCreateResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) EdgeUpdate(ctx context.Context, in *EdgeUpdateRequest) (*EdgeUpdateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdate")
	out := new(EdgeUpdateResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) EdgeCount(ctx context.Context, in *EdgeCountRequest) (*EdgeCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCount")
	out := new(EdgeCountResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) EdgeUpdateType(ctx context.Context, in *EdgeUpdateTypeRequest) (*EdgeUpdateTypeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdateType")
	out := new(EdgeUpdateTypeResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) EdgeDelete(ctx context.Context, in *EdgeDeleteRequest) (*EdgeDeleteResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeDelete")
	out := new(EdgeDeleteResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) EdgeList(ctx context.Context, in *EdgeListRequest) (*EdgeListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeList")
	out := new(EdgeListResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) EdgeUpdateAllEdgesFromNode(ctx context.Context, in *EdgeUpdateAllEdgesFromNodeRequest) (*EdgeUpdateAllEdgesFromNodeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdateAllEdgesFromNode")
	out := new(EdgeUpdateAllEdgesFromNodeResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) BatchEdgeGet(ctx context.Context, in *BatchEdgeGetRequest) (*BatchEdgeGetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "BatchEdgeGet")
	out := new(BatchEdgeGetResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) BulkEdgeUpdate(ctx context.Context, in *BulkEdgeUpdateRequest) (*BulkEdgeUpdateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeUpdate")
	out := new(BulkEdgeUpdateResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) BulkEdgeDelete(ctx context.Context, in *BulkEdgeDeleteRequest) (*BulkEdgeDeleteResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeDelete")
	out := new(BulkEdgeDeleteResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) BulkEdgeUpdateV2(ctx context.Context, in *BulkEdgeUpdateRequestV2) (*BulkEdgeUpdateResponseV2, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeUpdateV2")
	out := new(BulkEdgeUpdateResponseV2)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) BulkEdgeDeleteV2(ctx context.Context, in *BulkEdgeDeleteRequestV2) (*BulkEdgeDeleteResponseV2, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeDeleteV2")
	out := new(BulkEdgeDeleteResponseV2)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) NodeGet(ctx context.Context, in *NodeGetRequest) (*NodeGetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeGet")
	out := new(NodeGetResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[13], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) NodeCreate(ctx context.Context, in *NodeCreateRequest) (*NodeCreateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeCreate")
	out := new(NodeCreateResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[14], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) NodeUpdate(ctx context.Context, in *NodeUpdateRequest) (*NodeUpdateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeUpdate")
	out := new(NodeUpdateResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[15], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) NodeCount(ctx context.Context, in *NodeCountRequest) (*NodeCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeCount")
	out := new(NodeCountResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[16], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) NodeDelete(ctx context.Context, in *NodeDeleteRequest) (*NodeDeleteResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeDelete")
	out := new(NodeDeleteResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[17], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) NodeList(ctx context.Context, in *NodeListRequest) (*NodeListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeList")
	out := new(NodeListResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[18], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) Multi(ctx context.Context, in *MultiRequest) (*MultiResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "Multi")
	out := new(MultiResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[19], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBProtobufClient) MultiAsync(ctx context.Context, in *MultiAsyncRequest) (*MultiAsyncResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "MultiAsync")
	out := new(MultiAsyncResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[20], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ===================
// GraphDB JSON Client
// ===================

type graphDBJSONClient struct {
	client HTTPClient
	urls   [21]string
}

// NewGraphDBJSONClient creates a JSON client that implements the GraphDB interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewGraphDBJSONClient(addr string, client HTTPClient) GraphDB {
	prefix := urlBase(addr) + GraphDBPathPrefix
	urls := [21]string{
		prefix + "EdgeGet",
		prefix + "EdgeCreate",
		prefix + "EdgeUpdate",
		prefix + "EdgeCount",
		prefix + "EdgeUpdateType",
		prefix + "EdgeDelete",
		prefix + "EdgeList",
		prefix + "EdgeUpdateAllEdgesFromNode",
		prefix + "BatchEdgeGet",
		prefix + "BulkEdgeUpdate",
		prefix + "BulkEdgeDelete",
		prefix + "BulkEdgeUpdateV2",
		prefix + "BulkEdgeDeleteV2",
		prefix + "NodeGet",
		prefix + "NodeCreate",
		prefix + "NodeUpdate",
		prefix + "NodeCount",
		prefix + "NodeDelete",
		prefix + "NodeList",
		prefix + "Multi",
		prefix + "MultiAsync",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &graphDBJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &graphDBJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *graphDBJSONClient) EdgeGet(ctx context.Context, in *EdgeGetRequest) (*EdgeGetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeGet")
	out := new(EdgeGetResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) EdgeCreate(ctx context.Context, in *EdgeCreateRequest) (*EdgeCreateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCreate")
	out := new(EdgeCreateResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) EdgeUpdate(ctx context.Context, in *EdgeUpdateRequest) (*EdgeUpdateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdate")
	out := new(EdgeUpdateResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) EdgeCount(ctx context.Context, in *EdgeCountRequest) (*EdgeCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCount")
	out := new(EdgeCountResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) EdgeUpdateType(ctx context.Context, in *EdgeUpdateTypeRequest) (*EdgeUpdateTypeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdateType")
	out := new(EdgeUpdateTypeResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) EdgeDelete(ctx context.Context, in *EdgeDeleteRequest) (*EdgeDeleteResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeDelete")
	out := new(EdgeDeleteResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) EdgeList(ctx context.Context, in *EdgeListRequest) (*EdgeListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeList")
	out := new(EdgeListResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) EdgeUpdateAllEdgesFromNode(ctx context.Context, in *EdgeUpdateAllEdgesFromNodeRequest) (*EdgeUpdateAllEdgesFromNodeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdateAllEdgesFromNode")
	out := new(EdgeUpdateAllEdgesFromNodeResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) BatchEdgeGet(ctx context.Context, in *BatchEdgeGetRequest) (*BatchEdgeGetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "BatchEdgeGet")
	out := new(BatchEdgeGetResponse)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) BulkEdgeUpdate(ctx context.Context, in *BulkEdgeUpdateRequest) (*BulkEdgeUpdateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeUpdate")
	out := new(BulkEdgeUpdateResponse)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) BulkEdgeDelete(ctx context.Context, in *BulkEdgeDeleteRequest) (*BulkEdgeDeleteResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeDelete")
	out := new(BulkEdgeDeleteResponse)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) BulkEdgeUpdateV2(ctx context.Context, in *BulkEdgeUpdateRequestV2) (*BulkEdgeUpdateResponseV2, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeUpdateV2")
	out := new(BulkEdgeUpdateResponseV2)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) BulkEdgeDeleteV2(ctx context.Context, in *BulkEdgeDeleteRequestV2) (*BulkEdgeDeleteResponseV2, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeDeleteV2")
	out := new(BulkEdgeDeleteResponseV2)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) NodeGet(ctx context.Context, in *NodeGetRequest) (*NodeGetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeGet")
	out := new(NodeGetResponse)
	err := doJSONRequest(ctx, c.client, c.urls[13], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) NodeCreate(ctx context.Context, in *NodeCreateRequest) (*NodeCreateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeCreate")
	out := new(NodeCreateResponse)
	err := doJSONRequest(ctx, c.client, c.urls[14], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) NodeUpdate(ctx context.Context, in *NodeUpdateRequest) (*NodeUpdateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeUpdate")
	out := new(NodeUpdateResponse)
	err := doJSONRequest(ctx, c.client, c.urls[15], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) NodeCount(ctx context.Context, in *NodeCountRequest) (*NodeCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeCount")
	out := new(NodeCountResponse)
	err := doJSONRequest(ctx, c.client, c.urls[16], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) NodeDelete(ctx context.Context, in *NodeDeleteRequest) (*NodeDeleteResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeDelete")
	out := new(NodeDeleteResponse)
	err := doJSONRequest(ctx, c.client, c.urls[17], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) NodeList(ctx context.Context, in *NodeListRequest) (*NodeListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "NodeList")
	out := new(NodeListResponse)
	err := doJSONRequest(ctx, c.client, c.urls[18], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) Multi(ctx context.Context, in *MultiRequest) (*MultiResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "Multi")
	out := new(MultiResponse)
	err := doJSONRequest(ctx, c.client, c.urls[19], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *graphDBJSONClient) MultiAsync(ctx context.Context, in *MultiAsyncRequest) (*MultiAsyncResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithMethodName(ctx, "MultiAsync")
	out := new(MultiAsyncResponse)
	err := doJSONRequest(ctx, c.client, c.urls[20], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ======================
// GraphDB Server Handler
// ======================

type graphDBServer struct {
	GraphDB
	hooks *twirp.ServerHooks
}

func NewGraphDBServer(svc GraphDB, hooks *twirp.ServerHooks) TwirpServer {
	return &graphDBServer{
		GraphDB: svc,
		hooks:   hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *graphDBServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// GraphDBPathPrefix is used for all URL paths on a twirp GraphDB server.
// Requests are always: POST GraphDBPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const GraphDBPathPrefix = "/twirp/graphdb.GraphDB/"

func (s *graphDBServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "graphdb")
	ctx = ctxsetters.WithServiceName(ctx, "GraphDB")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/graphdb.GraphDB/EdgeGet":
		s.serveEdgeGet(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/EdgeCreate":
		s.serveEdgeCreate(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/EdgeUpdate":
		s.serveEdgeUpdate(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/EdgeCount":
		s.serveEdgeCount(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/EdgeUpdateType":
		s.serveEdgeUpdateType(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/EdgeDelete":
		s.serveEdgeDelete(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/EdgeList":
		s.serveEdgeList(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/EdgeUpdateAllEdgesFromNode":
		s.serveEdgeUpdateAllEdgesFromNode(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/BatchEdgeGet":
		s.serveBatchEdgeGet(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/BulkEdgeUpdate":
		s.serveBulkEdgeUpdate(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/BulkEdgeDelete":
		s.serveBulkEdgeDelete(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/BulkEdgeUpdateV2":
		s.serveBulkEdgeUpdateV2(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/BulkEdgeDeleteV2":
		s.serveBulkEdgeDeleteV2(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/NodeGet":
		s.serveNodeGet(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/NodeCreate":
		s.serveNodeCreate(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/NodeUpdate":
		s.serveNodeUpdate(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/NodeCount":
		s.serveNodeCount(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/NodeDelete":
		s.serveNodeDelete(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/NodeList":
		s.serveNodeList(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/Multi":
		s.serveMulti(ctx, resp, req)
		return
	case "/twirp/graphdb.GraphDB/MultiAsync":
		s.serveMultiAsync(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *graphDBServer) serveEdgeGet(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeGetJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeGetProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeGetJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeGet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeGetRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeGetResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeGet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeGetResponse and nil error while calling EdgeGet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeGetProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeGet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeGetRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeGetResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeGet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeGetResponse and nil error while calling EdgeGet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeCreate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeCreateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeCreateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeCreateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCreate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeCreateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeCreateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeCreate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeCreateResponse and nil error while calling EdgeCreate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeCreateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCreate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeCreateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeCreateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeCreate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeCreateResponse and nil error while calling EdgeCreate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeUpdate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeUpdateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeUpdateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeUpdateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeUpdateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeUpdateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeUpdateResponse and nil error while calling EdgeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeUpdateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeUpdateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeUpdateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeUpdateResponse and nil error while calling EdgeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeCountResponse and nil error while calling EdgeCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeCountRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeCountResponse and nil error while calling EdgeCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeUpdateType(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeUpdateTypeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeUpdateTypeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeUpdateTypeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdateType")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeUpdateTypeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeUpdateTypeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeUpdateType(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeUpdateTypeResponse and nil error while calling EdgeUpdateType. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeUpdateTypeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdateType")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeUpdateTypeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeUpdateTypeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeUpdateType(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeUpdateTypeResponse and nil error while calling EdgeUpdateType. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeDelete(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeDeleteJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeDeleteProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeDeleteJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeDelete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeDeleteRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeDeleteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeDelete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeDeleteResponse and nil error while calling EdgeDelete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeDeleteProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeDelete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeDeleteRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeDeleteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeDelete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeDeleteResponse and nil error while calling EdgeDelete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeListResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeListResponse and nil error while calling EdgeList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeListResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeListResponse and nil error while calling EdgeList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeUpdateAllEdgesFromNode(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeUpdateAllEdgesFromNodeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeUpdateAllEdgesFromNodeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveEdgeUpdateAllEdgesFromNodeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdateAllEdgesFromNode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeUpdateAllEdgesFromNodeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeUpdateAllEdgesFromNodeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeUpdateAllEdgesFromNode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeUpdateAllEdgesFromNodeResponse and nil error while calling EdgeUpdateAllEdgesFromNode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveEdgeUpdateAllEdgesFromNodeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdateAllEdgesFromNode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EdgeUpdateAllEdgesFromNodeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EdgeUpdateAllEdgesFromNodeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.EdgeUpdateAllEdgesFromNode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeUpdateAllEdgesFromNodeResponse and nil error while calling EdgeUpdateAllEdgesFromNode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveBatchEdgeGet(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBatchEdgeGetJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBatchEdgeGetProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveBatchEdgeGetJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BatchEdgeGet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BatchEdgeGetRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BatchEdgeGetResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.BatchEdgeGet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BatchEdgeGetResponse and nil error while calling BatchEdgeGet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveBatchEdgeGetProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BatchEdgeGet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(BatchEdgeGetRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BatchEdgeGetResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.BatchEdgeGet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BatchEdgeGetResponse and nil error while calling BatchEdgeGet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveBulkEdgeUpdate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkEdgeUpdateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkEdgeUpdateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveBulkEdgeUpdateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkEdgeUpdateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkEdgeUpdateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.BulkEdgeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEdgeUpdateResponse and nil error while calling BulkEdgeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveBulkEdgeUpdateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(BulkEdgeUpdateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkEdgeUpdateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.BulkEdgeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEdgeUpdateResponse and nil error while calling BulkEdgeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveBulkEdgeDelete(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkEdgeDeleteJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkEdgeDeleteProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveBulkEdgeDeleteJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeDelete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkEdgeDeleteRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkEdgeDeleteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.BulkEdgeDelete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEdgeDeleteResponse and nil error while calling BulkEdgeDelete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveBulkEdgeDeleteProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeDelete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(BulkEdgeDeleteRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkEdgeDeleteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.BulkEdgeDelete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEdgeDeleteResponse and nil error while calling BulkEdgeDelete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveBulkEdgeUpdateV2(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkEdgeUpdateV2JSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkEdgeUpdateV2Protobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveBulkEdgeUpdateV2JSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeUpdateV2")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkEdgeUpdateRequestV2)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkEdgeUpdateResponseV2
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.BulkEdgeUpdateV2(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEdgeUpdateResponseV2 and nil error while calling BulkEdgeUpdateV2. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveBulkEdgeUpdateV2Protobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeUpdateV2")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(BulkEdgeUpdateRequestV2)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkEdgeUpdateResponseV2
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.BulkEdgeUpdateV2(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEdgeUpdateResponseV2 and nil error while calling BulkEdgeUpdateV2. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveBulkEdgeDeleteV2(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkEdgeDeleteV2JSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkEdgeDeleteV2Protobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveBulkEdgeDeleteV2JSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeDeleteV2")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkEdgeDeleteRequestV2)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkEdgeDeleteResponseV2
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.BulkEdgeDeleteV2(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEdgeDeleteResponseV2 and nil error while calling BulkEdgeDeleteV2. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveBulkEdgeDeleteV2Protobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeDeleteV2")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(BulkEdgeDeleteRequestV2)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkEdgeDeleteResponseV2
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.BulkEdgeDeleteV2(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEdgeDeleteResponseV2 and nil error while calling BulkEdgeDeleteV2. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeGet(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeGetJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeGetProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveNodeGetJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeGet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeGetRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeGetResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.NodeGet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeGetResponse and nil error while calling NodeGet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeGetProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeGet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeGetRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeGetResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.NodeGet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeGetResponse and nil error while calling NodeGet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeCreate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeCreateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeCreateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveNodeCreateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeCreate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeCreateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeCreateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.NodeCreate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeCreateResponse and nil error while calling NodeCreate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeCreateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeCreate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeCreateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeCreateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.NodeCreate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeCreateResponse and nil error while calling NodeCreate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeUpdate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeUpdateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeUpdateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveNodeUpdateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeUpdateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeUpdateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.NodeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeUpdateResponse and nil error while calling NodeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeUpdateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeUpdateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeUpdateResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.NodeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeUpdateResponse and nil error while calling NodeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveNodeCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.NodeCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeCountResponse and nil error while calling NodeCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeCountRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.NodeCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeCountResponse and nil error while calling NodeCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeDelete(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeDeleteJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeDeleteProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveNodeDeleteJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeDelete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeDeleteRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeDeleteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.NodeDelete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeDeleteResponse and nil error while calling NodeDelete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeDeleteProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeDelete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeDeleteRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeDeleteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.NodeDelete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeDeleteResponse and nil error while calling NodeDelete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveNodeListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeListResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.NodeList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeListResponse and nil error while calling NodeList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveNodeListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *NodeListResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.NodeList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *NodeListResponse and nil error while calling NodeList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveMulti(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveMultiJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveMultiProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveMultiJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Multi")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(MultiRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *MultiResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.Multi(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MultiResponse and nil error while calling Multi. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveMultiProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Multi")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(MultiRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *MultiResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.Multi(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MultiResponse and nil error while calling Multi. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveMultiAsync(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveMultiAsyncJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveMultiAsyncProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *graphDBServer) serveMultiAsyncJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MultiAsync")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(MultiAsyncRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *MultiAsyncResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.MultiAsync(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MultiAsyncResponse and nil error while calling MultiAsync. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) serveMultiAsyncProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MultiAsync")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(MultiAsyncRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *MultiAsyncResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GraphDB.MultiAsync(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MultiAsyncResponse and nil error while calling MultiAsync. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *graphDBServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *graphDBServer) ProtocGenTwirpVersion() string {
	return "v5.5.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.5.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1935 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0x4f, 0x6f, 0x23, 0x49,
	0x15, 0xb7, 0xbb, 0xdb, 0x63, 0xe7, 0x25, 0xf1, 0x78, 0x6b, 0x92, 0xac, 0xd3, 0x61, 0x98, 0xa4,
	0x76, 0x17, 0x32, 0x03, 0x72, 0x84, 0x07, 0x98, 0x10, 0xb4, 0x41, 0x76, 0x1c, 0x66, 0x59, 0x66,
	0x00, 0x75, 0x76, 0x82, 0x16, 0x81, 0xac, 0x4e, 0xba, 0xc6, 0xe3, 0x5d, 0xbb, 0xdb, 0x74, 0xb7,
	0x13, 0x45, 0xda, 0x1b, 0xdc, 0x38, 0x72, 0xe0, 0xcc, 0x0d, 0x09, 0x89, 0x4f, 0xc0, 0x17, 0xe0,
	0x88, 0x38, 0xf1, 0x35, 0xf8, 0x04, 0xa8, 0xfe, 0x74, 0x77, 0x55, 0xff, 0xb1, 0x3b, 0x24, 0xe2,
	0xe6, 0xaa, 0xf7, 0xff, 0xbd, 0x5f, 0xbd, 0x7e, 0x55, 0x86, 0x47, 0x33, 0xdf, 0x0b, 0xbd, 0x83,
	0x91, 0x6f, 0xcf, 0xde, 0x39, 0x17, 0x1d, 0xb6, 0x42, 0x75, 0xb1, 0x34, 0x9f, 0x8c, 0x3c, 0x6f,
	0x34, 0x21, 0x07, 0x6c, 0xfb, 0x62, 0xfe, 0xf6, 0x20, 0x1c, 0x4f, 0x49, 0x10, 0xda, 0xd3, 0x19,
	0xe7, 0xc4, 0x7f, 0xd3, 0xe1, 0xbd, 0xd7, 0xf3, 0x49, 0x38, 0xee, 0x05, 0x37, 0xee, 0xa5, 0x45,
	0x7e, 0x3b, 0x27, 0x41, 0x88, 0x06, 0xd0, 0xf0, 0xf9, 0xcf, 0xa0, 0x5d, 0xdd, 0xd5, 0xf7, 0x57,
	0xbb, 0xfb, 0x9d, 0xc8, 0x42, 0x86, 0xbb, 0x73, 0x36, 0x76, 0x47, 0x13, 0x22, 0x56, 0x56, 0x2c,
	0x89, 0xf6, 0xa1, 0x35, 0xf3, 0xbd, 0x4b, 0x12, 0x04, 0x43, 0x87, 0x4c, 0xec, 0x9b, 0xe1, 0x34,
	0x68, 0x6b, 0xbb, 0xd5, 0x7d, 0xdd, 0x6a, 0x8a, 0xfd, 0x01, 0xdd, 0x7e, 0x1d, 0x98, 0x7f, 0xd1,
	0x60, 0x5d, 0xd1, 0x82, 0x3e, 0x86, 0x55, 0xe2, 0x8c, 0xc8, 0xf0, 0xd2, 0x27, 0x76, 0x48, 0xda,
	0xd5, 0xdd, 0xea, 0xfe, 0x6a, 0xd7, 0x8c, 0x9d, 0x38, 0x75, 0x46, 0xe4, 0x84, 0x91, 0x84, 0xc0,
	0x27, 0x15, 0x0b, 0x48, 0xbc, 0x19, 0x8b, 0xcf, 0x67, 0x0e, 0x15, 0xd7, 0x72, 0xc4, 0xdf, 0x30,
	0x52, 0x4a, 0x9c, 0x6f, 0xc6, 0xe2, 0x0e, 0x99, 0x90, 0x90, 0xb4, 0xf5, 0x1c, 0xf1, 0x01, 0x23,
	0xa5, 0xc4, 0xf9, 0x26, 0xfa, 0x14, 0x5a, 0xdc, 0xf9, 0x77, 0xb6, 0x3b, 0x22, 0xc3, 0xf0, 0x66,
	0x46, 0xda, 0x06, 0xd3, 0xf1, 0xf5, 0x1c, 0x17, 0x3e, 0xbb, 0x99, 0x49, 0x7a, 0x9a, 0x2c, 0x0a,
	0x26, 0x48, 0x09, 0xfd, 0x26, 0xac, 0x89, 0x84, 0x32, 0x3d, 0x78, 0x03, 0x90, 0x5c, 0x81, 0x60,
	0xe6, 0xb9, 0x01, 0xc1, 0x7f, 0x35, 0x60, 0x8d, 0x6d, 0x47, 0xf9, 0xfb, 0x51, 0xa6, 0x82, 0x1f,
	0xa8, 0x15, 0x5c, 0x52, 0x3c, 0xf3, 0x5f, 0x7a, 0xba, 0x24, 0xdf, 0x85, 0x06, 0x8b, 0x6a, 0x44,
	0x42, 0x51, 0x8f, 0xf7, 0x95, 0x68, 0x5e, 0x92, 0x30, 0x09, 0xa3, 0x4e, 0xf8, 0x4e, 0xba, 0x90,
	0xda, 0xdd, 0x0a, 0xa9, 0xdf, 0xb2, 0x90, 0x47, 0x00, 0xdc, 0xba, 0x37, 0x77, 0x43, 0x51, 0x83,
	0x6d, 0xd5, 0x38, 0xa5, 0x24, 0xc2, 0x2b, 0x24, 0xda, 0x4b, 0x83, 0xa0, 0x76, 0x0f, 0x20, 0x78,
	0xf0, 0xbf, 0x81, 0x00, 0xbd, 0x00, 0xe6, 0xd7, 0x70, 0x32, 0x0e, 0xc2, 0x76, 0x9d, 0x29, 0x69,
	0x2b, 0x4a, 0x5e, 0x8d, 0x03, 0x29, 0x08, 0x56, 0x27, 0xba, 0x95, 0x46, 0xcf, 0xa7, 0x46, 0x43,
	0x6b, 0xe9, 0xf8, 0xdf, 0x06, 0xac, 0x0b, 0x10, 0x70, 0xfc, 0xa0, 0x1e, 0x85, 0x0b, 0xff, 0x2d,
	0xe0, 0xf2, 0x51, 0x1a, 0x2e, 0x9c, 0x1a, 0xe3, 0x85, 0x2f, 0xad, 0x58, 0xcc, 0xfc, 0xbd, 0x01,
	0x4d, 0x95, 0x88, 0xbe, 0x97, 0x41, 0x4c, 0x3b, 0x8b, 0x18, 0xce, 0x2b, 0x43, 0xe6, 0x38, 0x0f,
	0x32, 0x3b, 0xb9, 0x90, 0x89, 0x85, 0x65, 0xcc, 0x1c, 0xe7, 0x61, 0x66, 0x27, 0x17, 0x33, 0xaa,
	0xbc, 0x00, 0xcd, 0x0f, 0x73, 0x40, 0x63, 0xe6, 0x81, 0x26, 0x96, 0x96, 0x50, 0x73, 0x9c, 0x87,
	0x9a, 0x9d, 0x5c, 0xd4, 0xa8, 0xc6, 0x05, 0x6c, 0x7e, 0x5a, 0x08, 0x9b, 0x27, 0x85, 0xb0, 0x89,
	0x15, 0xa5, 0x71, 0x73, 0x98, 0xc5, 0xcd, 0x76, 0x0e, 0x6e, 0x62, 0xf9, 0x18, 0x38, 0xe8, 0x1b,
	0x50, 0x23, 0xbe, 0xef, 0xf9, 0xed, 0x0d, 0x26, 0xd5, 0x4c, 0xa4, 0xe8, 0xee, 0x27, 0x15, 0x8b,
	0x93, 0xfb, 0x0f, 0x61, 0x3d, 0x42, 0x00, 0xef, 0x4f, 0x7b, 0x50, 0x63, 0x2c, 0xa8, 0x0d, 0xf5,
	0x29, 0x09, 0x02, 0x7b, 0xc4, 0xbb, 0xf7, 0x8a, 0x15, 0x2d, 0xf1, 0x57, 0xb0, 0x97, 0x44, 0xd0,
	0x9b, 0x4c, 0xe8, 0x22, 0xf8, 0xb1, 0xef, 0x4d, 0x7f, 0xe6, 0x39, 0x71, 0xb7, 0xd9, 0x03, 0xe3,
	0xad, 0xef, 0x4d, 0x05, 0x6e, 0xd6, 0x63, 0xfb, 0x8c, 0x87, 0x91, 0xd0, 0x36, 0x34, 0xbc, 0x89,
	0xc3, 0x53, 0xa4, 0x71, 0x13, 0xde, 0xc4, 0x61, 0x81, 0x6f, 0x43, 0xc3, 0x25, 0xd7, 0x9c, 0xa4,
	0x73, 0x92, 0x4b, 0xae, 0x29, 0x09, 0x7f, 0x08, 0x78, 0x91, 0x75, 0xd1, 0x50, 0xdf, 0xc0, 0x66,
	0xee, 0xe1, 0xa4, 0x7e, 0xd1, 0x24, 0x65, 0xfc, 0xa2, 0xdc, 0x16, 0x23, 0x29, 0xc6, 0x35, 0xd5,
	0x78, 0x0f, 0xb6, 0xf2, 0x8b, 0x87, 0xbe, 0xa9, 0xe8, 0x7d, 0x14, 0xeb, 0x7d, 0xe5, 0xd9, 0x0e,
	0x71, 0x12, 0xed, 0xf8, 0x0b, 0x78, 0x2f, 0xd3, 0x7a, 0xca, 0x78, 0xd5, 0x85, 0xfa, 0x15, 0xf1,
	0x83, 0xb1, 0xe7, 0x8a, 0x13, 0x95, 0x9c, 0x45, 0xaa, 0x65, 0xec, 0x13, 0xe7, 0x9c, 0xd3, 0xad,
	0x88, 0x11, 0x7f, 0x0c, 0x28, 0x0b, 0xd8, 0xf2, 0xae, 0x7e, 0x05, 0x0f, 0x53, 0xcd, 0xa9, 0x4c,
	0x59, 0x77, 0x04, 0x68, 0xa5, 0xfc, 0x31, 0x5c, 0xb2, 0xc2, 0x3e, 0x05, 0x63, 0x46, 0x21, 0xc5,
	0x0f, 0xf5, 0x66, 0x2c, 0xff, 0x0b, 0x7b, 0x44, 0x9c, 0xe8, 0x2b, 0xc6, 0x58, 0xf0, 0x25, 0xb4,
	0xd2, 0x10, 0x47, 0x5b, 0xf0, 0xe0, 0x72, 0xee, 0x07, 0x9e, 0x2f, 0x30, 0x29, 0x56, 0xe8, 0x3b,
	0x50, 0xa3, 0x26, 0x82, 0xb6, 0xce, 0x9a, 0xdf, 0x4e, 0x2a, 0xa6, 0x13, 0xc6, 0x25, 0x62, 0xe3,
	0x9c, 0xa2, 0x95, 0x5a, 0xdc, 0x88, 0xfc, 0x15, 0xb9, 0x6b, 0x8c, 0xf8, 0x29, 0xaf, 0xb0, 0xd2,
	0x64, 0xd0, 0x06, 0xd4, 0x78, 0x3f, 0xaa, 0xb2, 0x09, 0x8a, 0x2f, 0xf0, 0x7f, 0xaa, 0x9c, 0x57,
	0xf9, 0x06, 0x96, 0x41, 0xc3, 0x87, 0x60, 0x38, 0x76, 0x68, 0x0b, 0x28, 0xb4, 0x62, 0x96, 0x81,
	0x1d, 0xda, 0x7d, 0x7b, 0x64, 0x31, 0x2a, 0xfa, 0x08, 0x9a, 0xde, 0x15, 0xf1, 0xaf, 0xfd, 0x71,
	0x48, 0x86, 0x8c, 0x9f, 0xe6, 0xbd, 0x61, 0xad, 0xc7, 0xbb, 0x94, 0x1f, 0xfd, 0x00, 0x80, 0xf7,
	0x6a, 0x67, 0x68, 0x4b, 0x0d, 0x93, 0x8d, 0x9e, 0x9d, 0x68, 0xf4, 0xec, 0x7c, 0x16, 0x8d, 0x9e,
	0xd6, 0x8a, 0xe0, 0xee, 0x85, 0x32, 0x2a, 0x6b, 0xb7, 0x44, 0xa5, 0xda, 0xc3, 0xcb, 0xa3, 0xf2,
	0x4f, 0x22, 0x67, 0xca, 0xd8, 0x71, 0x7f, 0x39, 0x53, 0x93, 0xa1, 0xdf, 0x22, 0x19, 0x51, 0x60,
	0xea, 0xc7, 0xad, 0x7c, 0x60, 0xcf, 0xa1, 0xa9, 0xce, 0x61, 0x25, 0x82, 0xc2, 0x47, 0xfc, 0x8c,
	0x4a, 0x9f, 0xe2, 0xf2, 0x06, 0x8f, 0xe0, 0x51, 0xdf, 0x0e, 0x2f, 0xdf, 0xa5, 0xac, 0x7e, 0x10,
	0x1d, 0x26, 0x3e, 0x49, 0xa4, 0xcc, 0x72, 0x1a, 0xee, 0xc1, 0x86, 0x2a, 0x2b, 0x8c, 0x3f, 0x55,
	0x85, 0x73, 0xad, 0x0b, 0x15, 0x7f, 0xae, 0xc2, 0x66, 0x7f, 0x3e, 0xf9, 0x32, 0xf7, 0x00, 0xdc,
	0xa9, 0xcb, 0x44, 0x95, 0xd6, 0x17, 0x56, 0x1a, 0xc3, 0x3a, 0xed, 0xf3, 0x89, 0x1a, 0x83, 0xa9,
	0x59, 0x75, 0xc9, 0xf5, 0x69, 0x74, 0x96, 0xdb, 0xb0, 0x95, 0x76, 0x51, 0x7c, 0x61, 0x7e, 0x99,
	0x38, 0x9f, 0xe9, 0xe5, 0x77, 0x6a, 0x1f, 0x92, 0x49, 0xb5, 0x71, 0xe3, 0x3f, 0x56, 0xe1, 0xfd,
	0xdc, 0x84, 0x9d, 0x77, 0xef, 0x9c, 0xb2, 0x4c, 0x32, 0xf4, 0x4c, 0x32, 0x68, 0x0f, 0x9b, 0x8c,
	0xa7, 0x63, 0xde, 0x22, 0x6a, 0x16, 0x5f, 0xe0, 0x0e, 0xb4, 0xf3, 0x53, 0x74, 0xde, 0x45, 0x08,
	0x8c, 0xa9, 0xe7, 0x73, 0x28, 0x36, 0x2c, 0xf6, 0x1b, 0x7b, 0x49, 0x10, 0x4a, 0xe2, 0xee, 0x21,
	0x88, 0xd8, 0x41, 0xbd, 0xc0, 0x41, 0x35, 0xa1, 0x05, 0x0e, 0x3e, 0x03, 0x83, 0x1a, 0xa4, 0x34,
	0x66, 0x85, 0x7f, 0x6a, 0xd8, 0x6f, 0xd4, 0x04, 0x6d, 0xec, 0x08, 0xbb, 0xda, 0xd8, 0xc1, 0x16,
	0x00, 0x07, 0x36, 0x93, 0xd8, 0x03, 0xc3, 0xf5, 0x1c, 0x52, 0xe0, 0xbf, 0x2b, 0x58, 0xa4, 0x26,
	0xb4, 0xae, 0x40, 0x93, 0xe3, 0x12, 0xff, 0x1a, 0x0c, 0xea, 0x6b, 0x99, 0x6c, 0x3c, 0x06, 0x2d,
	0xf4, 0x32, 0xba, 0x18, 0x83, 0x16, 0x7a, 0x71, 0x04, 0x7a, 0x12, 0x41, 0xe2, 0x71, 0x64, 0x63,
	0x59, 0xdb, 0x8c, 0x3c, 0x36, 0x8a, 0x3d, 0x7e, 0x0e, 0x4d, 0x6a, 0x53, 0xed, 0x5c, 0x4b, 0x32,
	0x41, 0x3b, 0x57, 0x2c, 0x94, 0x74, 0x2e, 0x49, 0x2a, 0xdd, 0x3b, 0x24, 0x59, 0xfa, 0x0d, 0xa0,
	0xcb, 0xcc, 0x37, 0x60, 0x59, 0xfa, 0xff, 0x1f, 0xdf, 0x00, 0xd9, 0xb1, 0xdb, 0x06, 0xf6, 0x3b,
	0x11, 0x58, 0xa6, 0x1f, 0xde, 0x4f, 0x60, 0xe5, 0x06, 0x82, 0x28, 0x88, 0xec, 0x17, 0xba, 0x5c,
	0x10, 0x07, 0xd0, 0x62, 0x39, 0x90, 0x87, 0xaa, 0x1d, 0x58, 0xa1, 0xb4, 0xa1, 0x74, 0xa2, 0x1a,
	0x74, 0x23, 0x9a, 0x98, 0x24, 0x81, 0x85, 0x13, 0xd3, 0xf7, 0x39, 0x6b, 0xa6, 0xe5, 0x2e, 0x43,
	0x9b, 0x08, 0x29, 0x3b, 0x0a, 0x97, 0x0b, 0xe9, 0x0f, 0x55, 0x58, 0x93, 0x67, 0xd4, 0xc2, 0x49,
	0x34, 0x6e, 0x41, 0xfc, 0xa5, 0x8c, 0x2f, 0xe8, 0x7c, 0xea, 0xf9, 0x0e, 0xf1, 0x59, 0xba, 0x9b,
	0xd2, 0x7c, 0x2a, 0xeb, 0xec, 0xfc, 0x9c, 0xb2, 0x58, 0x9c, 0x13, 0x9b, 0x50, 0x63, 0x6b, 0x54,
	0x07, 0xbd, 0x77, 0x76, 0xd2, 0xaa, 0xa0, 0x06, 0x18, 0x83, 0xd3, 0xb3, 0x93, 0x56, 0x15, 0x7f,
	0xce, 0x8f, 0x8e, 0x3c, 0x98, 0x2f, 0xca, 0x6f, 0x3c, 0x75, 0x6b, 0xcb, 0xa7, 0xee, 0x57, 0xf0,
	0x30, 0x35, 0xb8, 0xd1, 0xd3, 0xc0, 0xaf, 0xe2, 0xec, 0x34, 0x54, 0x97, 0x9f, 0x06, 0xc1, 0xdd,
	0x0b, 0xf1, 0x6f, 0x38, 0x12, 0xca, 0xce, 0xf0, 0xd4, 0xe1, 0xa0, 0xad, 0x2d, 0x9c, 0xe1, 0x59,
	0x51, 0x38, 0x27, 0x7e, 0x03, 0x28, 0x4b, 0x2c, 0x5d, 0x54, 0xc9, 0x13, 0x4d, 0xf6, 0x24, 0xab,
	0x96, 0xb5, 0xca, 0xb2, 0x63, 0x55, 0xa1, 0xda, 0xbf, 0x57, 0xc1, 0xc8, 0x99, 0xb7, 0xab, 0xb7,
	0x99, 0xb7, 0xd5, 0x5a, 0x68, 0xb7, 0xa8, 0x05, 0xbd, 0xd0, 0x47, 0xa3, 0xba, 0xce, 0xb0, 0x19,
	0x2d, 0xe3, 0xde, 0x61, 0x2c, 0xea, 0x1d, 0xf8, 0x1f, 0x3a, 0xd4, 0xc5, 0x0e, 0xea, 0x80, 0x31,
	0x76, 0xe3, 0xa7, 0x49, 0x33, 0x2d, 0xd1, 0xf9, 0x89, 0x1b, 0x06, 0xa7, 0x6e, 0xe8, 0xdf, 0x58,
	0x8c, 0x8f, 0xd6, 0xf6, 0xc2, 0xf3, 0x26, 0xd9, 0xda, 0x46, 0x02, 0x7d, 0x4a, 0xe5, 0x12, 0x9c,
	0x13, 0xbd, 0x80, 0x7a, 0x10, 0xfa, 0x63, 0x77, 0x14, 0x5d, 0xea, 0x1e, 0x67, 0x84, 0xce, 0x38,
	0x9d, 0x8b, 0x45, 0xdc, 0x54, 0xd0, 0xf1, 0xe6, 0x17, 0x13, 0x12, 0xb4, 0x8d, 0x02, 0xc1, 0x01,
	0xa7, 0x0b, 0x41, 0xc1, 0x6d, 0xbe, 0x80, 0x95, 0xd8, 0x6f, 0xd4, 0x02, 0xfd, 0x4b, 0x72, 0x23,
	0x20, 0x4a, 0x7f, 0xd2, 0x93, 0x7d, 0x65, 0x4f, 0xe6, 0x24, 0x3a, 0xd9, 0x6c, 0x71, 0xa4, 0x1d,
	0x56, 0xcd, 0x43, 0x80, 0xc4, 0xff, 0x65, 0x92, 0x0d, 0x59, 0xf2, 0x08, 0xd6, 0xe4, 0x20, 0x96,
	0xc9, 0xae, 0xa4, 0x64, 0xe5, 0x38, 0x96, 0xc9, 0x56, 0x25, 0xd9, 0xee, 0x3f, 0xd7, 0xa0, 0xfe,
	0x92, 0x26, 0x65, 0xd0, 0x47, 0xc7, 0x50, 0x17, 0x43, 0x3c, 0x2a, 0x7a, 0x10, 0x36, 0x0b, 0xdf,
	0xfd, 0x70, 0x05, 0xbd, 0x04, 0x48, 0x6e, 0x3d, 0x68, 0xc1, 0xd3, 0xb0, 0xb9, 0xe8, 0x0d, 0x30,
	0x51, 0x24, 0x5e, 0xf1, 0x16, 0x3c, 0x12, 0x9b, 0x8b, 0x1e, 0x03, 0x71, 0x05, 0x0d, 0x60, 0x25,
	0xbe, 0x80, 0xa3, 0xe2, 0xe7, 0x62, 0x73, 0xc1, 0xa3, 0x20, 0xae, 0xa0, 0x33, 0x7e, 0x1d, 0x4b,
	0xde, 0x7a, 0xd0, 0x92, 0x87, 0x5f, 0x73, 0xd9, 0x0b, 0x5f, 0x12, 0xa3, 0x78, 0x2c, 0x5c, 0xf0,
	0x1a, 0x6d, 0x2e, 0x7a, 0x73, 0xc4, 0x15, 0xd4, 0x83, 0x46, 0xf4, 0x3a, 0x82, 0x0a, 0xdf, 0x92,
	0xcd, 0xe2, 0xd7, 0x42, 0x5c, 0x41, 0xd7, 0x60, 0x16, 0xbf, 0xa4, 0xa1, 0x67, 0x39, 0xc1, 0x14,
	0x3c, 0xf6, 0x99, 0xdf, 0x2a, 0xc5, 0x1b, 0x1b, 0x7e, 0x0d, 0x6b, 0xf2, 0xdd, 0x11, 0x7d, 0x2d,
	0x16, 0xcf, 0xb9, 0x8e, 0x9a, 0x8f, 0x0b, 0xa8, 0x72, 0xa1, 0xd4, 0x0b, 0x88, 0x54, 0xa8, 0xdc,
	0xeb, 0x92, 0x54, 0xa8, 0x82, 0xcb, 0x9d, 0xa2, 0x54, 0x14, 0x2b, 0xab, 0x54, 0x2d, 0xd8, 0x93,
	0x42, 0x7a, 0xac, 0xf4, 0x73, 0x68, 0xa9, 0x06, 0xcf, 0xbb, 0x68, 0x77, 0xb1, 0xaf, 0xe7, 0x5d,
	0x73, 0x6f, 0x89, 0xb7, 0xe7, 0x5d, 0x55, 0x35, 0x37, 0x9b, 0xab, 0x3a, 0x75, 0xe1, 0xca, 0x51,
	0x9d, 0xbe, 0x21, 0xe1, 0x0a, 0x6d, 0x10, 0x62, 0x50, 0x97, 0x1a, 0x84, 0x3a, 0xef, 0x4b, 0x0d,
	0x22, 0x35, 0xd3, 0x73, 0xcc, 0x27, 0x23, 0xb1, 0x84, 0xf9, 0xcc, 0x00, 0x2f, 0x61, 0x3e, 0x3b,
	0x43, 0x27, 0x8a, 0x32, 0x0d, 0x22, 0x33, 0x30, 0xa7, 0x14, 0xe5, 0x35, 0x88, 0x78, 0xde, 0x94,
	0x1a, 0x44, 0x7a, 0x68, 0x35, 0xcd, 0x3c, 0x52, 0xda, 0x9d, 0xcc, 0x59, 0xce, 0xcc, 0xa7, 0x29,
	0x77, 0xf2, 0xce, 0x72, 0x34, 0x25, 0x21, 0x35, 0x91, 0xf9, 0x67, 0x39, 0x3d, 0x52, 0xe1, 0x0a,
	0x3a, 0x84, 0x1a, 0xfb, 0x9f, 0x07, 0x6d, 0xe6, 0xfe, 0x4d, 0x68, 0x6e, 0xe5, 0xff, 0x1d, 0xc4,
	0xa3, 0x48, 0xfe, 0x90, 0x94, 0xa2, 0xc8, 0xfc, 0x4f, 0x2c, 0x45, 0x91, 0xf3, 0x0f, 0x66, 0xa5,
	0xff, 0xed, 0x5f, 0x3d, 0xbb, 0xf4, 0x1c, 0xd2, 0xf9, 0x62, 0x1e, 0x84, 0x63, 0xb7, 0x13, 0x5e,
	0x1d, 0xbc, 0x25, 0xc4, 0x09, 0xa2, 0xbf, 0xb6, 0x0f, 0x94, 0x3f, 0xba, 0x2f, 0x1e, 0xb0, 0xe5,
	0xf3, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0xfa, 0xc9, 0xae, 0xae, 0x00, 0x1f, 0x00, 0x00,
}
