# spade
[![GoDoc](https://img.shields.io/badge/godoc-reference-5272B4.svg?style=flat-square)](https://godoc.internal.justin.tv/code.justin.tv/hygienic/spade)
[![Build Status](https://jenkins.internal.justin.tv/buildStatus/icon?job=hygienic/spade/master)](https://jenkins.internal.justin.tv/job/hygienic/job/spade/job/master/)

Spade is a client to send events to spade.

# Usage

```go
var dconf distconf.Distconf
// ... setup distconf if you want

// Load spade config
config := spadedconf.Config{}
err := config.Load(&dconf)
if err != nil {
  return err
}

// Enable ability to combine small batches (optional)
config.CombineSmallBatches = true

// Create a spade client
spadeClient := spade.Client{
  Config: &config,
}

err = spadeClient.Setup()
if err != nil {
  return err
}

// Must call Start() to drain the channel
go func() {
  err := spadeClient.Start()
  if err != nil {
    fmt.Printf("error starting spade client: %v", err)
  }
}()

// Queue an event
spadeClient.QueueEvents(spade.Event{
  Name: "feed_server_post",
  Properties: struct {
    AuthorID string `json:"author_id"`
  }{
    AuthorID: "1234",
  },
})

// ...
// When done, close the spade client
err = spadeClient.Close()
if err != nil {
  return err
}

return nil
```
