package models

type LoginRenameEvent struct {
	UserID   string `json:"user_id"`
	OldLogin string `json:"old_login"`
	NewLogin string `json:"new_login"`
	Env      string `json:"environment"`
}

type DisplaynameChangeEvent struct {
	UserID         string `json:"user_id"`
	OldDisplayname string `json:"old_displayname"`
	NewDisplayname string `json:"new_displayname"`
	Env            string `json:"environment"`
}

type BanUserEvent struct {
	ReporterID    string `json:"reporter_id"`
	TargetID      string `json:"target_id"`
	Reason        string `json:"reason"`
	Duration      string `json:"duration"`
	IPBanDuration int64  `json:"ip_ban_duration"`
	Type          string `json:"type"`
	Env           string `json:"environment"`
}

type SignupEvent struct {
	UserID   string `json:"user_id"`
	Login    string `json:"login"`
	IP       string `json:"ip"`
	DeviceID string `json:"device_id"`
	Env      string `json:"environment"`
}

type UpdateChannelEvent struct {
	ChannelID              string  `json:"channel_id"`
	Channel                string  `json:"channel"`
	OldStatus              *string `json:"old_status"`
	Status                 *string `json:"status"`
	OldGame                *string `json:"old_game"`
	Game                   *string `json:"game"`
	OldBroadcasterLanguage *string `json:"old_broadcaster_language"`
	BroadcasterLanguage    *string `json:"broadcaster_language"`
	OldGameID              *uint64 `json:"old_game_id"`
	GameID                 *uint64 `json:"game_id"`
	Env                    string  `json:"environment"`
}

type SetUserImagesEvent struct {
	UserID    string           `json:"id"`
	OldImages *ImageProperties `json:"old_images"`
	NewImages *ImageProperties `json:"new_images"`
	Env       string           `json:"environment"`
}
