# GraphDB has been migrated to Fulton and this codebase has been deprecated

Fulton Codebase : https://code.amazon.com/packages/TwitchVXGraphDBECS/trees/mainline

# GraphDB Run Book

[![codecov](https://codecov.xarth.tv/ghe/feeds/graphdb/branch/master/graph/badge.svg)](https://codecov.xarth.tv/ghe/feeds/graphdb)

## GraphDB's big table of links

| Thing | Link |
|-------------|-----|
| Integration endpoint | https://integration.graphdb.twitch.a2z.com |
| Staging endpoint | https://staging.graphdb.twitch.a2z.com |
| Production endpoint | https://production.graphdb.twitch.a2z.com |
| Grafana dashboard | https://grafana.xarth.tv/dashboard/db/graphdb |
| Alerting (also via grafana) | https://grafana.xarth.tv/dashboard/db/graphdb |
| Source code | https://git.xarth.tv/feeds/graphdb |
| Code build | https://jenkins-og.xarth.tv/view/feeds/job/feeds-graphdb/ |
| Production AWS account | https://twitch-feed-aws.signin.aws.amazon.com/console |
| Dev AWS account | https://twitch-feed-dev.signin.aws.amazon.com/console |
| Build deployment | https://jenkins-og.xarth.tv/view/feeds/job/feeds-graphdb-pipeline/ |
| Container logs (twitch-feed-aws) | https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#logStream:group=feeds-production-container-logs |
| Configuration management (deprecated) | http://api.us-west-2.prod.consul.live-video.a2z.com/ |
| Password management | https://dashboard.xarth.tv/sandstorm/manage-secrets?nameFilter=graphdb |
| SSL cert management (twitch-feed-aws) | https://us-west-2.console.aws.amazon.com/acm/home?region=us-west-2#/ |
| db-s3-glue job(s) | [README](./terraform/dynamo-to-tahoe/README.md)
| Error logs | https://rollbar.com/Twitch/GraphDB/ |
| Slack channel | [#graphdb](https://twitch.slack.com/messages/graphdb) |
| Oncall rotation | https://twitchoncall.pagerduty.com/services/PAKT4XA |


## Service or system overview

### Business overview

GraphDB is a storage database that holds edge and node information, along with meta data information about the edges or
nodes.  It was designed as a replacement for Cohesion and currently is used for Twitch's following graph.

### Technical overview

The primary storage backend for GraphDB is DynamoDB.  Dynamo data is cached by elasticache/memcache to prevent hot keys.

### Service Level Agreements (SLAs)

We aim for 99% of single item read requests to respond in less than 50ms and 99% of single item write requests to respond
less than 100ms.

### Service owner

GraphDB is owned by discovery infra and is supported in slack on channel #graphdb

### Endpoints

DNS is managed by the Route53 in AWS.  We support both HTTPS and HTTP requests.

**Please use SSL when communicating with Graphdb**

| Environment | HTTP | HTTPS |
|-------------|-----| ----- |
| Integration | http://integration.graphdb.twitch.a2z.com | https://integration.graphdb.twitch.a2z.com |
| Staging | http://staging.graphdb.twitch.a2z.com | https://staging.graphdb.twitch.a2z.com |
| Production | http://production.graphdb.twitch.a2z.com | https://production.graphdb.twitch.a2z.com |

## Dependencies

### DynamoDB

DynamoDB is the source of truth for graph information.

#### Limits

DynamoDB uses auto scaling for read/write capacity.  When capacity jumps, it takes a few minutes for auto scaling to
catch up.  We cap at 12,500 write units and 9,000 read units.

#### What could go wrong?

DynamoDB is pretty reliable, but can spike with high p99 request times.  There is nothing we can do about that.

DynamoDB could temporarily throttle requests to reads or writes while capacity auto scales.  If you don't want to wait
for auto scaling, you can manually increase the read/write capacities.

If list requests take too long, we can throttle on our circuit breakers and return 'concurrency reached' errors.  If
this happens consistently, the solution is to increase our concurrent request limit in the code.

### Elasticache

All requests to DynamoDB first hit elasticache.

#### Limits

We are limited to 210GB stored in the cache.  Memcache is generally network bound and we are limited to 7,000	Mbps
per host.

#### What could go wrong?

If we run out of space, we could start evicting items.  This shouldn't be a concern if it happens at a low rate.

Our traffic pattern could change to avoid the cache. This would cause p99 times to increase.  The solution is to either
prepopulate more data into the cache or resolve what caused traffic patterns to change up stream.

If our instances do too much network traffic, we could begin serving requests slower than needed.  The solution there
is to deploy more elasticache instances into the cluster.

### SQS

SQS allows GraphDB to do asynchronous requests (write this later, etc) and repair count changes.

#### Limits

There are no practical limits how how much traffic we can send to SQS.  We are limited on draining traffic from SQS
based upon the number of hosts draining from SQS (Each ECS task processes one message at a time).  You can tell
if our SQS queue is hitting a limit if the number of messages in the queue begins to rise.

#### What could go wrong

We could not process messages fast enough, causing the queue size to rise. This usually means each messages is taking
longer than usual to processes.  Check other systems for a bottleneck.  For example, maybe DynamoDB capacity needs
to be increased.

### ECS

ECS is where GraphDB is deployed.  GraphDB will auto scale tasks to keep total CPU usage < 60%.

#### Limits

We are limited to the number of hosts in the cluster.  If we reach this limit, increase the size of the ECS cluster.

##### Scale Up

If there is room in the cluster (`feeds-<env>-common`) to deploy more tasks, we can increase the maximum number of tasks.

Otherwise, we need to deploy more hosts into the ecs cluster and increase the maximum number of tasks.

#### What could go wrong

A deployment could fail if the cluster does not have enough spare CPU or memory to deploy more tasks.  We are usually
CPU limited.  To increase the CPU of the cluster, deploy more hosts into it.

### ALB

All traffic to GraphDB goes through an ALB before hitting GraphDB.

#### Limits

There are no practical limits to GraphDB's use of an ALB.

#### What could go wrong

If the DNS of the ALB changes, it is possible for traffic to not find GraphDB.  You can adjust the DNS in Route53.

### Slack bot

A slack bot allows moderation and safety teams to perform common read/write operations on GraphDB autonomously without
having to file a ticket for us.

#### Limits

The Slack bot is deployed behind a lambda and API gateway and is limited to lambda: 1,000 concurrent instances.  We are
unlikely to hit this limit

#### What could go wrong

The slack bot is a low priority service and support can be delayed without an issue.  If the bot has trouble connecting
to GraphDB, it may need a new URL set inside the SSM parameter store at https://us-west-2.console.aws.amazon.com/ec2/v2/home?region=us-west-2#Parameters:sort=Name

The slack bot logs traffic to #graphdb-access-logs in slack.

## API

### Twirp

Twirp is the main way to communicate with GraphDB and the API is documented in the proto files of the service.
The twirp service `GraphDB` is the recommended way to communicate with GraphDB and the twirp service
`datastorerpc.Reader` is a transitional way to communicate with GraphDB that generally mirrors cohesion's API.

GraphDB also supports cohesion's old /v1 HTTP API with the same URLs as cohesion's.

## System characteristics

### Traffic hours

Traffic to the service follows twitch's normal web traffic patterns.

### Data and processing flows

All data to GraphDB comes from the ALB.

### Resilience, Fault Tolerance (FT) and High Availability (HA)

The service is currently only deployed in us-west-2.  It requires coordination the DynamoDB layer and uses hystrix
circuits to control open/close and breaking to dependencies.


### Throttling and partial shutdown

The service cannot be directly throttled, however it internally uses Hystrix to communicate with all downstream
dependencies and the hystrix circuits will return errors back to users if anything downstream is circuit open.

To explicitly throttle the service, you can increase or decrease the allowed concurrent connections to each hystrix
circuit.


### Environments

The service promotes through 4 stages: integration, staging, canary, and production.

#### Integration

Integration is used only for integration tests and any data here could be wiped without notice.  Integration talks to
the staging environment of other services that don't have a dedicated integration environment.

#### Staging

Staging data is generally persistent and talks to other staging data at twitch.

#### Canary

Canary is a single instance behind the production ALB.  It has dedicated log groups and all metrics go to the 'canary'
environment

#### Production

Production shares the ALB with canary and gets live traffic.

## Required resources

15,000 req/sec require 108 CPU units.  Memory isn't an issue and the 1GB of memory per task is more than enough.
On disk storage isn't used.  Network bandwidth availability could become an issue and is monitored at the ECS level.

The service expects to scale up to 40,000 req / sec.  To increase that number, allow more task instances in ECS.

## Security and access control

There is no access control on GraphDB other than being on the VPN.

## System configuration

### Secrets

Secrets are managed via sandstorm at (https://dashboard.xarth.tv/sandstorm/manage-secrets)
SSH access to the cluster is managed by ldap groups.

### Configuration management (deprecated)

Some old configuration is managed by https://git.xarth.tv/hygienic/distconf and stored in consul at
http://api.us-west-2.prod.consul.live-video.a2z.com

## System backup and restore

### Backup requirements

Only DynamoDB needs to be backed up, since it is the only source of truth for data.

Backups require point-in-time recovery to be enabled on all the DynamoDB tables.  You can learn more about those at
https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/PointInTimeRecovery.html

### Backup procedures

Backups are done automatically by DynamoDB and can be restored to any time in the past 35 days.

### Backup verification

As a part of our Security Availability Expectations, we should validate that backups are enabled for all tables. These are automatic through the configuration, but one can manually check by going to [AWS Console](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:) and checking each of the dynamo tables for `graphdb`.

### Restore procedures

Use Point-in-time recovery's UI to restore tables.  The tables will get a new name.  Then, update the node registry to
read from the new table names.

Make sure you restore both the counts and edges table at the same time from the same backup time.

## Monitoring and alerting

### Container stdout/stderr logs

All containers log their stdout and stderr to CloudWatch logs.  The direct link is https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#logStream:group=feeds-production-container-logs

### Access logs

All rest/twirp requests to GraphDB log an event to CloudWatch group graphdb-production-access-logs.  The direct
link to search those is https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#logEventViewer:group=graphdb-production-access-logs;start=PT30S

They log out as a JSON encoded protocol buffer.  Check out the file private.proto `message AccessLog` for the logged
fields.  Because the logs are JSON you can search them with the ClouWatch UI.  For example, `{$.status_code != "200" }`.

If you have the bash command `awslogs`, you can execute this to get the logs in stdout
```bash
AWS_PROFILE=twitch-feed-aws awslogs get graphdb-production-access-logs -f '{$.status_code!="200"}'
```

### Error logs

Errors are logged to rollbar at https://rollbar.com/Twitch/GraphDB/

### Metrics

Metrics are charted in grafana at https://grafana.xarth.tv/d/000001672/graphdb

### Alerts

We use grafana alerts.  All alerts are viewable on the grafana dashboard and forward to pager duty.

## Operational tasks

### SSH access

You can directly ssh to any EC2 instances when connected to Twitch VPN. If it doesn't work, try turning off teleport bastion by ```teleport-bastion disable```

### Code repository

Code is stored in https://git.xarth.tv/feeds/graphdb

### Code Build

Jenkins builds GraphDB into a Docker image at https://jenkins-og.xarth.tv/view/feeds/job/feeds-graphdb/

### Deployment

Jenkins deploys GraphDB in stages integration->staging->canary->production using pipelines at
https://jenkins-og.xarth.tv/view/feeds/job/feeds-graphdb-pipeline/

All code deploys to staging automatically but requires manual confirmation to promote to canary and production.

### Updating Infrastructure

Terraform is used to maintain and update all AWS infrastrucuture related to graphdb.

Download the CLI tool from here: https://www.terraform.io/downloads.html Terraform v0.11.14

```bash
#!/bin/bash
set -ex

terraform init
if [ ! -z “$1” ]; then
       terraform workspace select “$1"
       terraform init
fi

terraform apply -auto-approve=false
```

Store that script as tform.sh anywhere in your PATH.

Navigate to `graphdb/terraform/environments/full_environment` and execute tform commands.

Example: `tform.sh integration`

This will rollout changes to the integration environment.

#### Install Jenkins Terraform provider
1. Get the Terraform provider for Jenkins:

```sh
go get code.justin.tv/cconger/terraform-provider-jenkins
```

2. Create a `.terraformrc` file in your `$HOME` directory with the following contents:
```hcl
providers {
  jenkins = "/Users/$USER/go/bin/terraform-provider-jenkins"
}
```

3. Get your username and API token from Jenkins by going to https://jenkins.internal.justin.tv/, click on your name in the top right, go to `Configure`, and select `Show API Token...`.

4. Create a `.jenkins_auth` file in your `$HOME` directory with the following contents, replaced with your username and API token:
```
username:api_token
```

**CloudFormation** is used for draining infra for the AutoScalingGroup. See https://aws.amazon.com/blogs/compute/how-to-automate-container-instance-draining-in-amazon-ecs/

To execute the CloudFormation infra, run
```
make cloudformation_infra_<environment>
```

## Development

### Adding a new edge type

To add a new edge type:
1. Ask people to fill out a JIRA ticket with the following information: edge name, reverse edge name, Read capacity MAX staging and production, Write capacity MAX staging and production.  Use [this ticket](https://jira.twitch.com/browse/VDI-1290) as an example.
2. Create the tables for it via terraform.  You can use the [VIP table creation diff](https://git.xarth.tv/feeds/graphdb/commit/ebec56adf3f2d12d7d429bb0efa8b8b13ff39b5a) as an example.  This step is optional, but suggested.  If you skip this step, it will use the generic DynamoDB tables that have limited capacity.
3. Add the edge types to the registry for the integration, staging, and production GraphDB deployments.  This step is always required.
4. Redeploy GraphDB.  This step is always required.  You can just do a `replay` of the previous jenkins pipeline if you don't want to do a new code commit.

There is nothing automated for step 2 yet.  Commands on the command line looked like this for the VIP type:
```bash
#!/bin/bash
curl -X POST \
  https://integration.graphdb.twitch.a2z.com/twirp/graphdb.GraphDB/NodeCreate \
  -H 'Cache-Control: no-cache' \
  -H 'Content-Type: application/json' \
  -d '{
    "node": {
        "type": "_edge_registry",
        "id": "vip_of"
    },
    "data": {
        "strings": {
            "edge_table": "graphdb_integration_vip",
            "count_table": "graphdb_integration_vip_count",
            "reverse_name": "has_vip"
        }
    }
}'
curl -X POST \
  https://staging.graphdb.twitch.a2z.com/twirp/graphdb.GraphDB/NodeCreate \
  -H 'Cache-Control: no-cache' \
  -H 'Content-Type: application/json' \
  -d '{
    "node": {
        "type": "_edge_registry",
        "id": "vip_of"
    },
    "data": {
        "strings": {
            "edge_table": "graphdb_staging_vip",
            "count_table": "graphdb_staging_vip_count",
            "reverse_name": "has_vip"
        }
    }
}'
curl -X POST \
  https://production.graphdb.twitch.a2z.com/twirp/graphdb.GraphDB/NodeCreate \
  -H 'Cache-Control: no-cache' \
  -H 'Content-Type: application/json' \
  -d '{
    "node": {
        "type": "_edge_registry",
        "id": "vip_of"
    },
    "data": {
        "strings": {
            "edge_table": "graphdb_production_vip",
            "count_table": "graphdb_production_vip_count",
            "reverse_name": "has_vip"
        }
    }
}'
```
