package logs

import (
	"net/http"

	"code.justin.tv/feeds/log"
	"code.justin.tv/web/cohesion/clients"
)

// ErrorLogger conforms to cohesion's expected logger.
type ErrorLogger struct {
	Log log.Logger
}

var _ clients.ErrorLogger = &ErrorLogger{}

func (e *ErrorLogger) RequestError(req *http.Request, err error) {
	e.Log.Log("err", err, "url", req.URL)
}

func (e *ErrorLogger) RequestPanic(req *http.Request, i interface{}) {
	e.Log.Log("panic", i, "url", req.URL)
}
func (e *ErrorLogger) Error(err error) {
	e.Log.Log("err", err)
}
func (e *ErrorLogger) Panic(i interface{}) {
	e.Log.Log("panic", i)
}
