freeStyleJob('feeds-graphdb') {
  using 'TEMPLATE-autobuild'
  wrappers {
    credentialsBinding {
      string 'AWS_ACCESS_KEY', 'twitch-feed-dev-access-key'
      string 'AWS_SECRET_KEY', 'twitch-feed-dev-secret-key'
    }
  }

  scm {
    git {
      remote {
        github 'feeds/graphdb', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell './jenkins.sh'
    conditionalSteps {
      condition {
        shell 'test $GIT_BRANCH = "origin/master" && ./scripts/is-new-deploy.sh feeds graphdb $GIT_COMMIT'
      }
      runner('DontRun')
      steps {
        downstreamParameterized {
          trigger('feeds-graphdb-pipeline') {
            parameters {
              predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
            }
          }
        }
      }
    }
  }
}

freeStyleJob('feeds-graphdb-coverage') {
  using 'TEMPLATE-autobuild'

  scm {
    git {
      remote {
        github 'feeds/graphdb', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    environmentVariables {
      env('GIT_BRANCH', '${GIT_BRANCH}')
      env('GIT_COMMIT', '${GIT_COMMIT}')
      env('GIT_URL', '${GIT_URL}')
    }
  }

  steps {
    shell 'manta -v -f .manta-coverage.json'
  }

  publishers {
    reportQuality('feeds/graphdb', '.manta')
  }
}

