#!/bin/bash
set -ex
env
TEAM="feeds"
SERVICE="graphdb"
#
# NOTE: The following  commented out code appears to be the standard way of providing
# credentials to a jenkins job. However, it has stopped working for graphdb's integration
# tests which are run in CI. Keeping the code around so it is easy to revert to this system
# in the future if we choose to.
#
#if [ -z "$AWS_CONFIG_FILE" ]; then
#	CREDS="-v $HOME/.aws:/root/.aws:ro"
#else
#	CREDS="-e AWS_SHARED_CREDENTIALS_FILE=/awsconfig -v $AWS_CONFIG_FILE:/awsconfig:ro -e graphdb_aws.assume_role=arn:aws:iam::724951484461:role/feeds-graphdb-integration"
#fi
#
export AWS_ACCESS_KEY_ID=${AWS_ACCESS_KEY}
export AWS_SECRET_ACCESS_KEY=${AWS_SECRET_KEY}

aws sts get-caller-identity
CREDS="-e AWS_SECRET_ACCESS_KEY=$AWS_SECRET_ACCESS_KEY -e AWS_ACCESS_KEY_ID=$AWS_ACCESS_KEY_ID -e graphdb_aws.assume_role=arn:aws:iam::724951484461:role/feeds-graphdb-integration"
docker run -w /go/src/code.justin.tv/$TEAM/$SERVICE $CREDS  -v `pwd`:/go/src/code.justin.tv/$TEAM/$SERVICE docker.pkgs.xarth.tv/discovery/gobuilder:1.13.4-0 make jenkins
if [ -z "$GIT_COMMIT" ]; then
  GIT_COMMIT=$(git rev-parse --verify HEAD)-$(whoami)
fi
./scripts/build-tag-push.sh $TEAM $SERVICE $GIT_COMMIT ./cmd/$SERVICE/Dockerfile
./scripts/build-tag-push.sh $TEAM graphdb-migrate $GIT_COMMIT ./cmd/graphdb-migrate/Dockerfile
