// Code generated by protoc-gen-twirp v5.5.0, DO NOT EDIT.
// source: proto/datastore.proto

/*
Package datastorerpc is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.5.0.

It is generated from these files:
	proto/datastore.proto
*/
package datastorerpc

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ================
// Writer Interface
// ================

type Writer interface {
	// CreateAssoc writes records into the favorites table. There is a
	// unique constraint on the table preventing duplicate writes, so we
	// do not have to perform a check.
	// SLO@200ms
	CreateAssoc(context.Context, *CreateAssocRequest) (*CreateAssocResponse, error)

	// DeleteAssoc sets the hidden column as true for the relationship
	// expressed by the supplied args
	// SLO@200ms
	DeleteAssoc(context.Context, *DeleteAssocRequest) (*DeleteAssocResponse, error)

	// BulkDeleteAssoc deletes all of the associations of type ASSOCKIND for the
	// given EntityV1 ENTITY.
	// SLO@300ms
	BulkDeleteAssoc(context.Context, *BulkDeleteAssocRequest) (*BulkDeleteAssocResponse, error)

	// UpdateAssoc updates the databag attached to this association. It
	// merges the existing databag with the data in the provided `data`
	// argument giving priority to the latter.
	// SLO@200ms
	UpdateAssoc(context.Context, *UpdateAssocRequest) (*UpdateAssocResponse, error)

	// BatchUpdateAssoc takes in a slice of associations and updates each association
	// according the the data bag in each association
	// SLO@300ms
	BatchUpdateAssoc(context.Context, *BatchUpdateAssocRequest) (*BatchUpdateAssocResponse, error)

	// BulkUpdateAssoc updates the databag for all associations of type `assocKind`.
	// It merges the existing databags with the data in the provided `data` argument.
	// SLO@300ms
	BulkUpdateAssoc(context.Context, *BulkUpdateAssocRequest) (*BulkUpdateAssocResponse, error)
}

// ======================
// Writer Protobuf Client
// ======================

type writerProtobufClient struct {
	client HTTPClient
	urls   [6]string
}

// NewWriterProtobufClient creates a Protobuf client that implements the Writer interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewWriterProtobufClient(addr string, client HTTPClient) Writer {
	prefix := urlBase(addr) + WriterPathPrefix
	urls := [6]string{
		prefix + "CreateAssoc",
		prefix + "DeleteAssoc",
		prefix + "BulkDeleteAssoc",
		prefix + "UpdateAssoc",
		prefix + "BatchUpdateAssoc",
		prefix + "BulkUpdateAssoc",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &writerProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &writerProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *writerProtobufClient) CreateAssoc(ctx context.Context, in *CreateAssocRequest) (*CreateAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Writer")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAssoc")
	out := new(CreateAssocResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *writerProtobufClient) DeleteAssoc(ctx context.Context, in *DeleteAssocRequest) (*DeleteAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Writer")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAssoc")
	out := new(DeleteAssocResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *writerProtobufClient) BulkDeleteAssoc(ctx context.Context, in *BulkDeleteAssocRequest) (*BulkDeleteAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Writer")
	ctx = ctxsetters.WithMethodName(ctx, "BulkDeleteAssoc")
	out := new(BulkDeleteAssocResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *writerProtobufClient) UpdateAssoc(ctx context.Context, in *UpdateAssocRequest) (*UpdateAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Writer")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAssoc")
	out := new(UpdateAssocResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *writerProtobufClient) BatchUpdateAssoc(ctx context.Context, in *BatchUpdateAssocRequest) (*BatchUpdateAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Writer")
	ctx = ctxsetters.WithMethodName(ctx, "BatchUpdateAssoc")
	out := new(BatchUpdateAssocResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *writerProtobufClient) BulkUpdateAssoc(ctx context.Context, in *BulkUpdateAssocRequest) (*BulkUpdateAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Writer")
	ctx = ctxsetters.WithMethodName(ctx, "BulkUpdateAssoc")
	out := new(BulkUpdateAssocResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ==================
// Writer JSON Client
// ==================

type writerJSONClient struct {
	client HTTPClient
	urls   [6]string
}

// NewWriterJSONClient creates a JSON client that implements the Writer interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewWriterJSONClient(addr string, client HTTPClient) Writer {
	prefix := urlBase(addr) + WriterPathPrefix
	urls := [6]string{
		prefix + "CreateAssoc",
		prefix + "DeleteAssoc",
		prefix + "BulkDeleteAssoc",
		prefix + "UpdateAssoc",
		prefix + "BatchUpdateAssoc",
		prefix + "BulkUpdateAssoc",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &writerJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &writerJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *writerJSONClient) CreateAssoc(ctx context.Context, in *CreateAssocRequest) (*CreateAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Writer")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAssoc")
	out := new(CreateAssocResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *writerJSONClient) DeleteAssoc(ctx context.Context, in *DeleteAssocRequest) (*DeleteAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Writer")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAssoc")
	out := new(DeleteAssocResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *writerJSONClient) BulkDeleteAssoc(ctx context.Context, in *BulkDeleteAssocRequest) (*BulkDeleteAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Writer")
	ctx = ctxsetters.WithMethodName(ctx, "BulkDeleteAssoc")
	out := new(BulkDeleteAssocResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *writerJSONClient) UpdateAssoc(ctx context.Context, in *UpdateAssocRequest) (*UpdateAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Writer")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAssoc")
	out := new(UpdateAssocResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *writerJSONClient) BatchUpdateAssoc(ctx context.Context, in *BatchUpdateAssocRequest) (*BatchUpdateAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Writer")
	ctx = ctxsetters.WithMethodName(ctx, "BatchUpdateAssoc")
	out := new(BatchUpdateAssocResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *writerJSONClient) BulkUpdateAssoc(ctx context.Context, in *BulkUpdateAssocRequest) (*BulkUpdateAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Writer")
	ctx = ctxsetters.WithMethodName(ctx, "BulkUpdateAssoc")
	out := new(BulkUpdateAssocResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =====================
// Writer Server Handler
// =====================

type writerServer struct {
	Writer
	hooks *twirp.ServerHooks
}

func NewWriterServer(svc Writer, hooks *twirp.ServerHooks) TwirpServer {
	return &writerServer{
		Writer: svc,
		hooks:  hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *writerServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// WriterPathPrefix is used for all URL paths on a twirp Writer server.
// Requests are always: POST WriterPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const WriterPathPrefix = "/twirp/datastorerpc.Writer/"

func (s *writerServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Writer")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/datastorerpc.Writer/CreateAssoc":
		s.serveCreateAssoc(ctx, resp, req)
		return
	case "/twirp/datastorerpc.Writer/DeleteAssoc":
		s.serveDeleteAssoc(ctx, resp, req)
		return
	case "/twirp/datastorerpc.Writer/BulkDeleteAssoc":
		s.serveBulkDeleteAssoc(ctx, resp, req)
		return
	case "/twirp/datastorerpc.Writer/UpdateAssoc":
		s.serveUpdateAssoc(ctx, resp, req)
		return
	case "/twirp/datastorerpc.Writer/BatchUpdateAssoc":
		s.serveBatchUpdateAssoc(ctx, resp, req)
		return
	case "/twirp/datastorerpc.Writer/BulkUpdateAssoc":
		s.serveBulkUpdateAssoc(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *writerServer) serveCreateAssoc(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateAssocJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateAssocProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *writerServer) serveCreateAssocJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateAssocRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Writer.CreateAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateAssocResponse and nil error while calling CreateAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *writerServer) serveCreateAssocProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateAssocRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Writer.CreateAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateAssocResponse and nil error while calling CreateAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *writerServer) serveDeleteAssoc(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteAssocJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteAssocProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *writerServer) serveDeleteAssocJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteAssocRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Writer.DeleteAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAssocResponse and nil error while calling DeleteAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *writerServer) serveDeleteAssocProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteAssocRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Writer.DeleteAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAssocResponse and nil error while calling DeleteAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *writerServer) serveBulkDeleteAssoc(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkDeleteAssocJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkDeleteAssocProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *writerServer) serveBulkDeleteAssocJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkDeleteAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkDeleteAssocRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkDeleteAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Writer.BulkDeleteAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkDeleteAssocResponse and nil error while calling BulkDeleteAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *writerServer) serveBulkDeleteAssocProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkDeleteAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(BulkDeleteAssocRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkDeleteAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Writer.BulkDeleteAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkDeleteAssocResponse and nil error while calling BulkDeleteAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *writerServer) serveUpdateAssoc(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateAssocJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateAssocProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *writerServer) serveUpdateAssocJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateAssocRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Writer.UpdateAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateAssocResponse and nil error while calling UpdateAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *writerServer) serveUpdateAssocProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateAssocRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Writer.UpdateAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateAssocResponse and nil error while calling UpdateAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *writerServer) serveBatchUpdateAssoc(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBatchUpdateAssocJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBatchUpdateAssocProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *writerServer) serveBatchUpdateAssocJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BatchUpdateAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BatchUpdateAssocRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BatchUpdateAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Writer.BatchUpdateAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BatchUpdateAssocResponse and nil error while calling BatchUpdateAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *writerServer) serveBatchUpdateAssocProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BatchUpdateAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(BatchUpdateAssocRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BatchUpdateAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Writer.BatchUpdateAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BatchUpdateAssocResponse and nil error while calling BatchUpdateAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *writerServer) serveBulkUpdateAssoc(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkUpdateAssocJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkUpdateAssocProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *writerServer) serveBulkUpdateAssocJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkUpdateAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkUpdateAssocRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkUpdateAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Writer.BulkUpdateAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkUpdateAssocResponse and nil error while calling BulkUpdateAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *writerServer) serveBulkUpdateAssocProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkUpdateAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(BulkUpdateAssocRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkUpdateAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Writer.BulkUpdateAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkUpdateAssocResponse and nil error while calling BulkUpdateAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *writerServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *writerServer) ProtocGenTwirpVersion() string {
	return "v5.5.0"
}

// ================
// Reader Interface
// ================

type Reader interface {
	// GetAssoc returns an AssociationV1 populated with meta data about
	// the association. The direction of the provided AssociationV1 is
	// returned returned in the response association. The meta data also
	// reflects this, that is to say:
	// SLO@100ms
	GetAssoc(context.Context, *GetAssocRequest) (*GetAssocResponse, error)

	// BulkGetAssoc returns a slice of `associations.AssocResponse` for the
	// given entity. As this is a PostgreSQL data store offset, limit and
	// sort logic is passed in to facilitate pagination.
	// SLO@200ms
	BulkGetAssoc(context.Context, *BulkGetAssocRequest) (*BulkGetAssocResponse, error)

	// CountAssoc returns the number of edges to this node for the
	// specified type. If err is set, disregard the return value provided
	// SLO@100ms
	CountAssoc(context.Context, *CountAssocRequest) (*CountAssocResponse, error)

	// GetAllAssoc returns the relevant edges between 2 entities.
	// SLO@300ms
	GetAllAssoc(context.Context, *GetAllAssocRequest) (*GetAllAssocResponse, error)

	// GetAllAssocBatch returns the relevant edges from one EntityV1 to any of a list of other entities.
	// SLO@300ms
	GetAllAssocBatch(context.Context, *GetAllAssocBatchRequest) (*GetAllAssocBatchResponse, error)
}

// ======================
// Reader Protobuf Client
// ======================

type readerProtobufClient struct {
	client HTTPClient
	urls   [5]string
}

// NewReaderProtobufClient creates a Protobuf client that implements the Reader interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewReaderProtobufClient(addr string, client HTTPClient) Reader {
	prefix := urlBase(addr) + ReaderPathPrefix
	urls := [5]string{
		prefix + "GetAssoc",
		prefix + "BulkGetAssoc",
		prefix + "CountAssoc",
		prefix + "GetAllAssoc",
		prefix + "GetAllAssocBatch",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &readerProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &readerProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *readerProtobufClient) GetAssoc(ctx context.Context, in *GetAssocRequest) (*GetAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Reader")
	ctx = ctxsetters.WithMethodName(ctx, "GetAssoc")
	out := new(GetAssocResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readerProtobufClient) BulkGetAssoc(ctx context.Context, in *BulkGetAssocRequest) (*BulkGetAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Reader")
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetAssoc")
	out := new(BulkGetAssocResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readerProtobufClient) CountAssoc(ctx context.Context, in *CountAssocRequest) (*CountAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Reader")
	ctx = ctxsetters.WithMethodName(ctx, "CountAssoc")
	out := new(CountAssocResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readerProtobufClient) GetAllAssoc(ctx context.Context, in *GetAllAssocRequest) (*GetAllAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Reader")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllAssoc")
	out := new(GetAllAssocResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readerProtobufClient) GetAllAssocBatch(ctx context.Context, in *GetAllAssocBatchRequest) (*GetAllAssocBatchResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Reader")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllAssocBatch")
	out := new(GetAllAssocBatchResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ==================
// Reader JSON Client
// ==================

type readerJSONClient struct {
	client HTTPClient
	urls   [5]string
}

// NewReaderJSONClient creates a JSON client that implements the Reader interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewReaderJSONClient(addr string, client HTTPClient) Reader {
	prefix := urlBase(addr) + ReaderPathPrefix
	urls := [5]string{
		prefix + "GetAssoc",
		prefix + "BulkGetAssoc",
		prefix + "CountAssoc",
		prefix + "GetAllAssoc",
		prefix + "GetAllAssocBatch",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &readerJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &readerJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *readerJSONClient) GetAssoc(ctx context.Context, in *GetAssocRequest) (*GetAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Reader")
	ctx = ctxsetters.WithMethodName(ctx, "GetAssoc")
	out := new(GetAssocResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readerJSONClient) BulkGetAssoc(ctx context.Context, in *BulkGetAssocRequest) (*BulkGetAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Reader")
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetAssoc")
	out := new(BulkGetAssocResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readerJSONClient) CountAssoc(ctx context.Context, in *CountAssocRequest) (*CountAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Reader")
	ctx = ctxsetters.WithMethodName(ctx, "CountAssoc")
	out := new(CountAssocResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readerJSONClient) GetAllAssoc(ctx context.Context, in *GetAllAssocRequest) (*GetAllAssocResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Reader")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllAssoc")
	out := new(GetAllAssocResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readerJSONClient) GetAllAssocBatch(ctx context.Context, in *GetAllAssocBatchRequest) (*GetAllAssocBatchResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Reader")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllAssocBatch")
	out := new(GetAllAssocBatchResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =====================
// Reader Server Handler
// =====================

type readerServer struct {
	Reader
	hooks *twirp.ServerHooks
}

func NewReaderServer(svc Reader, hooks *twirp.ServerHooks) TwirpServer {
	return &readerServer{
		Reader: svc,
		hooks:  hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *readerServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// ReaderPathPrefix is used for all URL paths on a twirp Reader server.
// Requests are always: POST ReaderPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const ReaderPathPrefix = "/twirp/datastorerpc.Reader/"

func (s *readerServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "datastorerpc")
	ctx = ctxsetters.WithServiceName(ctx, "Reader")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/datastorerpc.Reader/GetAssoc":
		s.serveGetAssoc(ctx, resp, req)
		return
	case "/twirp/datastorerpc.Reader/BulkGetAssoc":
		s.serveBulkGetAssoc(ctx, resp, req)
		return
	case "/twirp/datastorerpc.Reader/CountAssoc":
		s.serveCountAssoc(ctx, resp, req)
		return
	case "/twirp/datastorerpc.Reader/GetAllAssoc":
		s.serveGetAllAssoc(ctx, resp, req)
		return
	case "/twirp/datastorerpc.Reader/GetAllAssocBatch":
		s.serveGetAllAssocBatch(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *readerServer) serveGetAssoc(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAssocJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAssocProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *readerServer) serveGetAssocJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAssocRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Reader.GetAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAssocResponse and nil error while calling GetAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *readerServer) serveGetAssocProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAssocRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Reader.GetAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAssocResponse and nil error while calling GetAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *readerServer) serveBulkGetAssoc(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkGetAssocJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkGetAssocProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *readerServer) serveBulkGetAssocJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkGetAssocRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkGetAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Reader.BulkGetAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkGetAssocResponse and nil error while calling BulkGetAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *readerServer) serveBulkGetAssocProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(BulkGetAssocRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkGetAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Reader.BulkGetAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkGetAssocResponse and nil error while calling BulkGetAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *readerServer) serveCountAssoc(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCountAssocJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCountAssocProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *readerServer) serveCountAssocJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CountAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CountAssocRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CountAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Reader.CountAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CountAssocResponse and nil error while calling CountAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *readerServer) serveCountAssocProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CountAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CountAssocRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CountAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Reader.CountAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CountAssocResponse and nil error while calling CountAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *readerServer) serveGetAllAssoc(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAllAssocJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllAssocProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *readerServer) serveGetAllAssocJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAllAssocRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Reader.GetAllAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllAssocResponse and nil error while calling GetAllAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *readerServer) serveGetAllAssocProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllAssoc")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAllAssocRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllAssocResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Reader.GetAllAssoc(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllAssocResponse and nil error while calling GetAllAssoc. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *readerServer) serveGetAllAssocBatch(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAllAssocBatchJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllAssocBatchProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *readerServer) serveGetAllAssocBatchJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllAssocBatch")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAllAssocBatchRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllAssocBatchResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Reader.GetAllAssocBatch(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllAssocBatchResponse and nil error while calling GetAllAssocBatch. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *readerServer) serveGetAllAssocBatchProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllAssocBatch")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAllAssocBatchRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllAssocBatchResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Reader.GetAllAssocBatch(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllAssocBatchResponse and nil error while calling GetAllAssocBatch. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *readerServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 1
}

func (s *readerServer) ProtocGenTwirpVersion() string {
	return "v5.5.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.5.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1321 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0xdd, 0x6e, 0x1b, 0x45,
	0x14, 0xce, 0xae, 0x37, 0x6b, 0xfb, 0x38, 0x4d, 0xcd, 0x38, 0x4d, 0x5c, 0x47, 0x4d, 0xd2, 0x25,
	0x8d, 0x02, 0x54, 0x36, 0xde, 0x4a, 0x15, 0x02, 0x09, 0xc8, 0x8f, 0x03, 0x6a, 0x44, 0x51, 0x37,
	0x25, 0x41, 0x48, 0xc8, 0x6c, 0xbc, 0xe3, 0x64, 0xa9, 0xbd, 0xe3, 0xce, 0x8e, 0x5b, 0x72, 0x8b,
	0x84, 0x78, 0x04, 0xae, 0xb8, 0xe5, 0x02, 0x21, 0x6e, 0xb8, 0x84, 0x1b, 0x5e, 0x01, 0xf1, 0x06,
	0xbc, 0x08, 0x9a, 0xd9, 0x59, 0x67, 0xff, 0x6c, 0x93, 0x50, 0xd1, 0x70, 0x65, 0xcf, 0x9c, 0x33,
	0xe7, 0xe7, 0xdb, 0xef, 0x9c, 0xf9, 0x81, 0x1b, 0x03, 0x4a, 0x18, 0x69, 0x38, 0x36, 0xb3, 0x7d,
	0x46, 0x28, 0xae, 0x8b, 0x31, 0x9a, 0x1b, 0x4d, 0xd0, 0x41, 0xa7, 0xb6, 0x7a, 0x42, 0xc8, 0x49,
	0x0f, 0x37, 0x84, 0xec, 0x78, 0xd8, 0x6d, 0x30, 0xb7, 0x8f, 0x7d, 0x66, 0xf7, 0x07, 0x81, 0x7a,
	0xad, 0x12, 0x58, 0x39, 0xa1, 0xf6, 0xe0, 0xd4, 0x39, 0x0e, 0x26, 0x8d, 0xf7, 0xa1, 0xd4, 0xa2,
	0xf4, 0x21, 0x61, 0x7b, 0x64, 0xe8, 0x39, 0xa8, 0x09, 0xb3, 0xb6, 0xef, 0x93, 0x4e, 0x55, 0x59,
	0x53, 0x36, 0x4b, 0xe6, 0x72, 0x3d, 0xea, 0xa2, 0xbe, 0xc5, 0x45, 0xae, 0xcd, 0x5c, 0xe2, 0x1d,
	0x36, 0xad, 0x40, 0xd3, 0x78, 0x17, 0x16, 0x5a, 0x94, 0x46, 0x44, 0xad, 0xaf, 0x5c, 0x9f, 0xf9,
	0x68, 0x03, 0x74, 0x9f, 0x0c, 0x69, 0x07, 0x4b, 0x5b, 0xf3, 0xf5, 0xd0, 0x73, 0x8b, 0x52, 0x42,
	0x2d, 0x29, 0x35, 0x0e, 0xe1, 0x86, 0x58, 0x6c, 0x61, 0x7f, 0x40, 0x3c, 0x1f, 0x1f, 0xb9, 0xec,
	0xf4, 0x23, 0xcc, 0x6c, 0x84, 0x40, 0x7b, 0xe2, 0x7a, 0x8e, 0x58, 0x5e, 0xb4, 0xc4, 0x7f, 0xf4,
	0x1a, 0x28, 0x76, 0x55, 0x1d, 0x1b, 0x5b, 0x68, 0xc3, 0x52, 0x6c, 0xe3, 0x21, 0x2c, 0x7d, 0x80,
	0xd9, 0x56, 0xaf, 0x27, 0x24, 0xdb, 0x36, 0xeb, 0x9c, 0x5a, 0xf8, 0xe9, 0x10, 0xfb, 0x0c, 0xdd,
	0x03, 0x5d, 0xc4, 0xee, 0x57, 0x95, 0xb5, 0xdc, 0xb4, 0x34, 0xa5, 0xaa, 0xf1, 0x39, 0x54, 0xd3,
	0xf6, 0x02, 0x77, 0xe8, 0x9d, 0x84, 0xc1, 0x57, 0x27, 0xc4, 0x16, 0xe6, 0x17, 0x1a, 0x7e, 0xa0,
	0x15, 0xd4, 0x72, 0xce, 0x38, 0x05, 0x14, 0x31, 0x1f, 0x46, 0xfa, 0x3a, 0x68, 0x5d, 0x4a, 0xfa,
	0x12, 0xc2, 0xc5, 0xb8, 0xd9, 0x96, 0xc7, 0x5c, 0x76, 0x76, 0xd8, 0xb4, 0x84, 0x0e, 0xda, 0x00,
	0x95, 0x11, 0x09, 0xce, 0x38, 0x4d, 0x95, 0x11, 0xe3, 0x53, 0xa8, 0xc4, 0x3c, 0xbd, 0xb8, 0x1c,
	0x7e, 0x54, 0xe0, 0x95, 0x1d, 0x32, 0xf4, 0xd8, 0xa5, 0x73, 0xb8, 0x0f, 0x20, 0x2c, 0xb6, 0xc5,
	0x97, 0x0f, 0x72, 0x59, 0xca, 0x08, 0x64, 0xdf, 0xf5, 0x1c, 0xab, 0x68, 0x87, 0x7f, 0x51, 0x13,
	0xf2, 0x8c, 0x04, 0x8b, 0x72, 0x62, 0x51, 0x35, 0xcb, 0x8d, 0x58, 0xa5, 0x33, 0xc2, 0x7f, 0x8d,
	0x37, 0x01, 0x45, 0x63, 0x95, 0x28, 0x2c, 0xc0, 0x6c, 0x87, 0xcf, 0x8a, 0x68, 0x73, 0x56, 0x30,
	0x90, 0xe9, 0xfd, 0xa1, 0x42, 0x65, 0x7b, 0xd8, 0x7b, 0xc2, 0xd1, 0xbb, 0xfa, 0x09, 0xa2, 0x2d,
	0xc8, 0xfb, 0x84, 0xb2, 0xf6, 0xf1, 0x59, 0x55, 0x5b, 0x53, 0x36, 0xe7, 0xcd, 0xcd, 0xf8, 0x92,
	0x8c, 0x54, 0xea, 0x07, 0x84, 0xb2, 0xed, 0x33, 0x5e, 0x9b, 0xfc, 0x17, 0x2d, 0x82, 0x4e, 0xba,
	0x5d, 0x1f, 0xb3, 0xea, 0xac, 0x80, 0x43, 0x8e, 0x38, 0x4a, 0x3d, 0xb7, 0xef, 0xb2, 0xaa, 0x1e,
	0xa0, 0x24, 0x06, 0x5c, 0xbb, 0x33, 0xa4, 0x3e, 0xa1, 0xd5, 0xbc, 0x28, 0x59, 0x39, 0x32, 0x96,
	0x41, 0x0f, 0xec, 0xa2, 0x3c, 0xe4, 0xb6, 0x0e, 0x76, 0xca, 0x33, 0xa8, 0x00, 0xda, 0x6e, 0xeb,
	0x60, 0xa7, 0xac, 0x1a, 0x8f, 0x60, 0x21, 0x1e, 0x88, 0xfc, 0x10, 0xff, 0xa4, 0x46, 0x47, 0xe5,
	0x1e, 0xa7, 0xe1, 0xf7, 0x0a, 0x5c, 0x7f, 0x19, 0xdf, 0x28, 0x28, 0xc0, 0xdc, 0xd4, 0x02, 0xfc,
	0x46, 0x81, 0xf2, 0x0b, 0xc9, 0x17, 0xdd, 0x87, 0xa2, 0x47, 0x58, 0xbb, 0xcb, 0x7b, 0xb7, 0x74,
	0x7c, 0x33, 0xe1, 0xf8, 0xbc, 0xb9, 0x5b, 0x05, 0x4f, 0xfe, 0x93, 0x38, 0x7d, 0x08, 0x85, 0x30,
	0x2e, 0x34, 0x0f, 0xaa, 0x1b, 0xb6, 0x5a, 0xd5, 0x75, 0xd0, 0x5d, 0xd9, 0x7c, 0xd5, 0x29, 0x64,
	0x13, 0x5a, 0xc6, 0x2e, 0xc0, 0xf9, 0x1c, 0xba, 0x09, 0x05, 0x3e, 0xdb, 0xf6, 0x19, 0x95, 0x16,
	0xf3, 0x7c, 0x7c, 0xc0, 0x28, 0x5a, 0x86, 0xa2, 0xeb, 0xb4, 0xbb, 0x84, 0xf6, 0x6d, 0x26, 0x6c,
	0x17, 0xad, 0x82, 0xeb, 0xec, 0x89, 0xb1, 0xf1, 0x83, 0x02, 0xc5, 0x11, 0xb0, 0x93, 0xac, 0xac,
	0x42, 0xc9, 0xf5, 0x9e, 0x61, 0xea, 0x63, 0x21, 0x0d, 0xec, 0x80, 0x9c, 0xe2, 0x0a, 0x2b, 0x50,
	0xc2, 0xcd, 0xf6, 0x68, 0x79, 0x4e, 0x28, 0x14, 0x71, 0x73, 0x5f, 0x1a, 0xe0, 0x72, 0xf3, 0x5c,
	0xae, 0x49, 0xb9, 0x19, 0xca, 0x6f, 0x01, 0xf8, 0xa7, 0x36, 0x75, 0xda, 0x82, 0x33, 0x9c, 0xfb,
	0x05, 0xab, 0x28, 0x66, 0xf6, 0x28, 0xe9, 0x1b, 0x77, 0x01, 0x1d, 0x51, 0x97, 0x61, 0x0b, 0x3f,
	0xc5, 0x3e, 0xfb, 0x78, 0xc0, 0x77, 0x0a, 0x9f, 0xd3, 0xbf, 0xef, 0xf2, 0xad, 0x4d, 0x84, 0x5b,
	0xb0, 0xe4, 0xc8, 0xf8, 0x55, 0x05, 0xb4, 0x43, 0xb1, 0xcd, 0xf0, 0x55, 0x65, 0x24, 0x5a, 0x07,
	0x8d, 0x0b, 0x05, 0x10, 0x25, 0xb3, 0x3c, 0xda, 0xa9, 0x77, 0x6d, 0x66, 0x6f, 0xdb, 0x27, 0x96,
	0x90, 0xa2, 0xf7, 0xe0, 0x5a, 0x87, 0xe7, 0xe1, 0x12, 0xaf, 0xed, 0xd8, 0x0c, 0x0b, 0x60, 0x4a,
	0x66, 0xad, 0x1e, 0x9c, 0x3c, 0xea, 0xe1, 0xc9, 0xa3, 0xfe, 0x38, 0x3c, 0x79, 0x58, 0x73, 0xe1,
	0x82, 0x5d, 0x9b, 0x61, 0x64, 0x42, 0x8e, 0x0c, 0x82, 0xa6, 0x51, 0x32, 0xd7, 0xe2, 0xf1, 0xa4,
	0x01, 0xb5, 0xb8, 0xb2, 0x71, 0x04, 0x95, 0x18, 0x78, 0xb2, 0x5c, 0xde, 0x06, 0x1d, 0x8b, 0x73,
	0x86, 0x44, 0xc3, 0x48, 0xd1, 0x3e, 0x75, 0x22, 0xb1, 0xe4, 0x8a, 0x07, 0x5a, 0x41, 0x29, 0xab,
	0xc6, 0x9f, 0x0a, 0xa0, 0x5d, 0xdc, 0xc3, 0x57, 0xf8, 0xb3, 0x48, 0xbc, 0xb4, 0x8b, 0xe0, 0x75,
	0x00, 0x95, 0x58, 0x56, 0x12, 0xaf, 0x58, 0xa7, 0x50, 0x2f, 0xd2, 0x29, 0x38, 0x56, 0xdf, 0x29,
	0x70, 0x2d, 0x6e, 0x6f, 0x1d, 0x14, 0x3c, 0x05, 0x23, 0x05, 0xa3, 0x4d, 0x50, 0x98, 0xf4, 0x36,
	0x89, 0x25, 0x0a, 0x43, 0x2b, 0xa0, 0x84, 0x1d, 0x2c, 0x4d, 0x3f, 0xc5, 0x89, 0xec, 0x2d, 0x5a,
	0x6c, 0x6f, 0xf9, 0x29, 0x8c, 0x2c, 0x3c, 0xaf, 0x71, 0x70, 0x71, 0x73, 0x4a, 0x68, 0x2a, 0x0e,
	0xf4, 0xcc, 0x69, 0xc7, 0x25, 0x6c, 0xa2, 0x37, 0x64, 0x27, 0xcc, 0x4d, 0xfe, 0xbc, 0xc1, 0xf9,
	0x54, 0xa4, 0xa1, 0x8d, 0x4d, 0xc3, 0xf8, 0x4b, 0x81, 0x45, 0xbe, 0xdd, 0xbd, 0x24, 0xe2, 0x5d,
	0xe2, 0x14, 0x71, 0x19, 0x0e, 0xae, 0xc2, 0x52, 0x2a, 0xc9, 0x80, 0x37, 0x92, 0x4f, 0x3f, 0xab,
	0x80, 0x3e, 0x19, 0x38, 0xff, 0xff, 0x96, 0x68, 0x42, 0xc1, 0xc3, 0xcf, 0x83, 0x18, 0x66, 0x27,
	0xc7, 0x90, 0xf7, 0xf0, 0xf3, 0x28, 0xa2, 0x17, 0xea, 0x82, 0xdf, 0x2a, 0x50, 0x89, 0x01, 0xf6,
	0xef, 0xca, 0x3a, 0x8c, 0x21, 0x77, 0x81, 0x18, 0xe4, 0xa7, 0xfb, 0x5a, 0x81, 0x25, 0x71, 0xf9,
	0xc9, 0xf8, 0x7e, 0x97, 0xb9, 0x57, 0x85, 0xa1, 0xa8, 0x17, 0x81, 0xe3, 0x2d, 0xa8, 0xa6, 0x63,
	0x90, 0x90, 0x2c, 0x82, 0x3e, 0xf4, 0x86, 0x3e, 0x76, 0xe4, 0x11, 0x5e, 0x8e, 0xe4, 0x99, 0xe7,
	0x77, 0x35, 0x28, 0xc0, 0x8c, 0xe8, 0xeb, 0xa0, 0x63, 0xc1, 0x80, 0x29, 0xfc, 0x93, 0x5a, 0xff,
	0x65, 0x11, 0x5e, 0x2d, 0x32, 0xca, 0xf2, 0xce, 0x00, 0x3f, 0xe0, 0x88, 0xf9, 0x8b, 0x06, 0xba,
	0x58, 0x4c, 0xd1, 0x63, 0x28, 0x45, 0xb6, 0x6f, 0x94, 0xf0, 0x90, 0x3e, 0x16, 0xd5, 0x6e, 0x4f,
	0xd0, 0x08, 0x9c, 0x18, 0x33, 0xdc, 0x6a, 0xa4, 0xb9, 0x24, 0xad, 0xa6, 0x9b, 0x6b, 0xd2, 0x6a,
	0x46, 0x67, 0x32, 0x66, 0xd0, 0x17, 0x70, 0x3d, 0xd1, 0xb6, 0xd0, 0x7a, 0xfa, 0xca, 0x94, 0x61,
	0xfd, 0xce, 0x14, 0xad, 0x68, 0xdc, 0x11, 0xd4, 0x92, 0x71, 0xa7, 0x39, 0x99, 0x8c, 0x3b, 0x03,
	0x72, 0x63, 0x06, 0x75, 0xa0, 0x9c, 0xac, 0x06, 0x94, 0x0c, 0x29, 0xbb, 0x62, 0x6b, 0x1b, 0xd3,
	0xd4, 0x92, 0xe0, 0x44, 0x7d, 0x64, 0x80, 0x93, 0xe1, 0xe2, 0xce, 0x14, 0xad, 0xd0, 0x83, 0xf9,
	0x5b, 0x0e, 0x74, 0x0b, 0xdb, 0x0e, 0xa6, 0x68, 0x1f, 0x0a, 0xe1, 0x05, 0x09, 0xdd, 0x8a, 0xaf,
	0x4f, 0x5c, 0xec, 0x6a, 0x2b, 0xe3, 0xc4, 0xa3, 0xc8, 0x8f, 0x60, 0x2e, 0x7a, 0xc3, 0x44, 0xb7,
	0xa7, 0x5e, 0x83, 0x6b, 0xc6, 0x24, 0x95, 0x91, 0xe1, 0x47, 0x00, 0xe7, 0x2f, 0x08, 0x68, 0x35,
	0x41, 0xdc, 0xe4, 0x3b, 0x48, 0x6d, 0x6d, 0xbc, 0x42, 0x94, 0x20, 0x91, 0xb7, 0x99, 0x24, 0x41,
	0xd2, 0x0f, 0x44, 0x49, 0x82, 0x64, 0x3c, 0xec, 0x04, 0x04, 0x49, 0x3e, 0x5d, 0x25, 0x09, 0x32,
	0xe6, 0xa9, 0x2c, 0x49, 0x90, 0x71, 0x2f, 0x60, 0xc6, 0xcc, 0x76, 0xf3, 0xb3, 0x46, 0x87, 0x38,
	0xb8, 0xfe, 0xe5, 0xd0, 0x67, 0xae, 0x57, 0x67, 0xcf, 0x1a, 0x5d, 0x8c, 0x1d, 0x3f, 0x7c, 0x6f,
	0x6c, 0x24, 0xde, 0x30, 0xe9, 0xa0, 0x73, 0xac, 0x8b, 0xb9, 0x7b, 0x7f, 0x07, 0x00, 0x00, 0xff,
	0xff, 0x33, 0x30, 0x13, 0x1c, 0xe0, 0x14, 0x00, 0x00,
}
