locals {
  science_job_role = "arn:aws:iam::673385534282:role/RedshiftCopyUnload"
}

resource "aws_iam_role" "read_only_role" {
  name               = "${local.service}_${terraform.workspace}_read_only"
  assume_role_policy = "${data.aws_iam_policy_document.read_edge_assume_role_policy.json}"
  description        = "External jobs can assume this role to do read operations for for ${local.service} in ${terraform.workspace}"
}

data "aws_iam_policy_document" "read_dynamodb_access" {
  statement {
    sid = "VisualEditor0"

    actions = [
      "dynamodb:BatchGetItem",
      "dynamodb:GetItem",
      "dynamodb:Query",
      "dynamodb:Scan",
      "dynamodb:DescribeTable",
    ]

    resources = [
      "arn:aws:dynamodb:*:${local.account_id}:table/${local.service}_${terraform.workspace}_*",
      "arn:aws:dynamodb:*:${local.account_id}:table/${local.service}_${terraform.workspace}_*/index/*",
    ]
  }
}

resource "aws_iam_role_policy_attachment" "read_only_permissions" {
  role       = "${aws_iam_role.read_only_role.name}"
  policy_arn = "${aws_iam_policy.read_edge_policy.arn}"
}

resource "aws_iam_policy" "read_edge_policy" {
  name        = "read_table_policy_${local.service}_${terraform.workspace}"
  description = "Allows READ ONLY access for the edge tables for ${local.service} in ${terraform.workspace}"

  policy = "${data.aws_iam_policy_document.read_dynamodb_access.json}"
}

data "aws_iam_policy_document" "read_edge_assume_role_policy" {
  statement {
    actions = ["sts:AssumeRole"]

    principals {
      type = "AWS"

      identifiers = [
        "${local.science_job_role}",
      ]
    }
  }
}
