locals {
  team    = "feeds"
  service = "graphdb"
}

provider "jenkins" {
  url                = "https://jenkins.internal.justin.tv"
  shared_credentials = "${file(pathexpand("~/.jenkins_auth"))}"
}

terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "feeds/graphdb-service.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

module "pipeline" {
  source            = "../../modules/promotion_pipeline"
  team           = "${local.team}"
  service        = "${local.service}"
  git_repository = "https://git.xarth.tv/${local.team}/${local.service}"
}
