locals {
  team    = "feeds"
  service = "graphdb"
}

variable "log_retention" {
  description = "How long to retain access logs"
}

resource "aws_cloudwatch_log_group" "logs" {
  name              = "${local.service}-${terraform.workspace}-access-logs"
  retention_in_days = "${var.log_retention}"

  tags {
    Environment = "${terraform.workspace}"
    Service     = "${local.service}"
    Team        = "${local.team}"
  }
}

module "consulconf_logs" {
  source      = "../consulconf"
  team        = "${local.team}"
  service     = "${local.service}"
  environment = "${terraform.workspace}"
  key         = "access_logs.log_group_name"
  value       = "${element(split(":", aws_cloudwatch_log_group.logs.arn), 6)}"
}

data "aws_iam_policy_document" "allow_send_access_logs" {
  statement {
    sid = "1"

    actions = [
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "logs:DescribeLogStreams",
    ]

    resources = [
      "${aws_cloudwatch_log_group.logs.arn}",
    ]
  }
}

resource "aws_iam_policy" "allow_send_access_logs_policy" {
  name        = "access_logs_policy_${local.service}_${terraform.workspace}"
  description = "Allows roles to send access logs for ${local.service} in ${terraform.workspace}"

  policy = "${data.aws_iam_policy_document.allow_send_access_logs.json}"
}

output iam_policy_arn {
  value = "${aws_iam_policy.allow_send_access_logs_policy.arn}"
}
