variable alb_arn {
  description = "ARN of ALB to monitor"
}

variable target_group_arn {
  description = "ARN of target group behind the ALB to monitor"
}

variable alarm_sns_arn {
  description = "SNS ARN to send alerts to"
}

// --- 4xx
variable http_4xx_threshold {
  default = 10000
}

variable http_4xx_period {
  default = 60
}

variable http_4xx_evaluation_periods {
  default = 5
}

// --- 5xx
variable http_5xx_threshold {
  default = 100
}

variable http_5xx_period {
  default = 60
}

variable http_5xx_evaluation_periods {
  default = 5
}

// -- latency
variable http_latency_threshold {
  default = 1
}

variable http_latency_period {
  default = 60
}

variable http_latency_evaluation_periods {
  default = 5
}

// --- Unhealthy hosts
variable unhealthy_host_threshold {
  default = 1
}

variable unhealthy_host_latency_period {
  default = 60
}

variable unhealthy_host_evaluation_periods {
  default = 5
}

module High4XX {
  source        = "./single_metric"
  metric_name   = "HTTPCode_Target_4XX_Count"
  alarm_sns_arn = "${var.alarm_sns_arn}"
  alb_arn       = "${var.alb_arn}"

  threshold          = "${var.http_4xx_threshold}"
  evaluation_periods = "${var.http_4xx_evaluation_periods}"
  period             = "${var.http_4xx_period}"
}

module High5XX {
  source        = "./single_metric"
  metric_name   = "HTTPCode_Target_5XX_Count"
  alarm_sns_arn = "${var.alarm_sns_arn}"
  alb_arn       = "${var.alb_arn}"

  threshold          = "${var.http_5xx_threshold}"
  evaluation_periods = "${var.http_5xx_evaluation_periods}"
  period             = "${var.http_5xx_period}"
}

module AvgLatency {
  source        = "./single_metric"
  metric_name   = "TargetResponseTime"
  alarm_sns_arn = "${var.alarm_sns_arn}"
  alb_arn       = "${var.alb_arn}"

  threshold          = "${var.http_latency_threshold}"
  evaluation_periods = "${var.http_latency_evaluation_periods}"
  period             = "${var.http_latency_period}"
  statistic          = "Average"
}

module UnhealthyHosts {
  source        = "./targetgroup_metric"
  metric_name   = "UnHealthyHostCount"
  alarm_sns_arn = "${var.alarm_sns_arn}"
  alb_arn       = "${var.alb_arn}"

  threshold          = "${var.unhealthy_host_threshold}"
  evaluation_periods = "${var.unhealthy_host_evaluation_periods}"
  period             = "${var.unhealthy_host_latency_period}"
  target_group_arn   = "${var.target_group_arn}"
}
