variable "team" {
  description = "The twitch team (feeds/events/etc) that wants this resource"
}

variable "service" {
  description = "Name of the service (duplo/visage/etc) storing this configuration"
}

variable "environment" {
  description = "Which env run of the service (staging/production/etc) this configuration belongs to"
}

variable "key" {
  description = "The suffix name of the consul key"
}

variable "value" {
  description = "The value to store in consul"
}

provider "consul" {
  address    = "api.us-west-2.prod.consul.live-video.a2z.com"
  datacenter = "us-west2"
}

resource "consul_keys" "app" {
  datacenter = "us-west2"

  key {
    path  = "settings/${var.team}/${var.environment}/${var.service}.${var.key}"
    value = "${var.value}"
  }
}