variable "team" {
  type        = "string"
  description = "The team is the name of the team owning the DynamoDB table. This string will be used to namespace the S3 script and output buckets."
}

variable "name" {
  type        = "string"
  description = "The name of the DynamoDB table to be exported to Tahoe. This name will be used as a prefix when naming other required resources."
}

variable "schema_version" {
  default     = 0
  description = "The schema version should be incremented any time the schema changes"
}

variable "schema" {
  type        = "string"
  description = "The schema is an JSON string of an array of maps where each map contains keys 'name' and 'type'."
}

variable "dynamodb_read_capacity_ratio" {
  default     = 0.20
  description = "The DynamoDB RCU ratio controls the percentage of read capacity which can be consumed by the Tahoe export. Example: 0.20 = 20% read capacity"
}

variable "dpu_count" {
  default     = 10
  description = "number of Data Processing Units (or DPUs) used to run the glue job."
}

variable "dynamodb_splits_count" {
  description = "Optional - number of tasks used to copy DynamoDB to S3. Valid from 1 to 1000000, inclusive."
  default     = 1
}

variable "trigger_schedule" {
  default     = "0 0,12 * * ? *"
  description = "Schedule by which the watcher job is triggered. Default is once every 12 hours."
}

variable "api_key_parameter_name" {
  type        = "string"
  description = "The API key parameter name is the name of your SecureString that contains the producer's API key. Example: 'moderatesdbexport-producer-api-key'"
}

variable "api_key_kms_key_id" {
  type        = "string"
  description = "The KMS Key ID is the KMS UUID to decrypt the SecureString key. Example: 'd896877f-fd04-4c4f-92c8-85baef26524c'"
}

variable "tahoe_producer_name" {
  type        = "string"
  description = "(Fill in after registering a Tahoe producer) The Tahoe producer name is the name of your registered producer. Example: 'moderatesdbexport'"
}

variable "tahoe_producer_role_arn" {
  type        = "string"
  description = "(Fill in after registering a Tahoe producer) The Tahoe producer role ARN is the IAM role for your registered producer. Example: 'arn:aws:iam::331582574546:role/producer-moderatesdbexport'"
}

variable "tahoe_view_name" {
  type        = "string"
  description = "The name of the Tahoe table. Use underscores instead of hyphens."
}

variable "output_fields" {
  type        = "list"
  description = "Required list of fields in the schema to export to Tahoe."
}

variable "cleaning_code" {
  type        = "string"
  description = "Optional Python code to clean data before export. See description in https://git.xarth.tv/stats/db-s3-glue/blob/master/glue.tf#L104"

  // By default, return the raw data without transformation.
  default = "return frame"
}
