locals {
  service        = "graphdb"
  container_port = "8000"
  region         = "us-west-2"
  task_cpu       = "1024"
  task_mem       = "512"
  team           = "feeds"
  lambda_bin     = "graphdb_dynamo_lambda"
}

variable "environment" {}

variable "security_groups" {
  description = "The security groups for the alb.  Usually .account.twitch_subnets_sg"
}

variable forward_endpoint {
  description = "Which URL to send DynamoDB updates to"
}

variable "subnets" {
  description = "The VPC id for the alb target group.  Usually .account.vpc_id"
}

variable "role_arn" {
  description = "ARN of the role the lambda should use"
}

resource "aws_lambda_function" "dynamo_stream_publisher" {
  filename      = "empty.zip"
  function_name = "${local.service}-${var.environment}-${local.lambda_bin}"
  role          = "${var.role_arn}"
  handler       = "${local.lambda_bin}"
  runtime       = "go1.x"
  description   = "Publishes ${local.service} DynamoDB stream updates back to the service for ${var.environment}"
  timeout       = 15

  environment {
    variables = {
      ENVIRONMENT             = "${terraform.workspace}"
      SERVICE                 = "${local.service}"
      TEAM                    = "${local.team}"
      DYNAMO_FORWARD_LOCATION = "${var.forward_endpoint}"
    }
  }

  vpc_config {
    security_group_ids = ["${var.security_groups}"]
    subnet_ids         = ["${split(",", "${var.subnets}")}"]
  }

  tags {
    Environment = "${terraform.workspace}"
    Service     = "${local.service}"
    Team        = "${local.team}"
  }
}

output lambda_arn {
  value = "${aws_lambda_function.dynamo_stream_publisher.arn}"
}
