locals {
  service = "graphdb"
  team    = "feeds"

  sandstorm_role_arns = {
    integration = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-integration"
    staging     = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-staging"
    canary      = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
    production  = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
  }

  sandstorm_role_arn = "${lookup(local.sandstorm_role_arns, var.environment)}"

  // map for whether to create iam roles for Jarvis access (0 = false, 1 = true)
  jarvis_permissions = {
    integration = 0
    staging     = 1
    canary      = 0
    production  = 1
  }
}

variable environment {}

variable iam_id {
  description = "IAM ID of the tasks for the cluster"
}

// We have many tables with many permissions
variable dynamodb_iam_policy_arn {
  description = "ARN of permissions to dynamodb tables"
}

variable access_logs_permissions_arn {
  description = "ARN of permissions to access logs"
}

variable async_queue_permissions_arn {
  description = "ARN of permissions to access async log"
}

resource "aws_iam_role_policy" "sandstorm_policy" {
  name = "${local.service}_${var.environment}_sandstorm"
  role = "${var.iam_id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Resource": [
        "${local.sandstorm_role_arn}"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}

resource "aws_iam_role" "twitch_telemetry_writer" {
  name                 = "twitch-telemetry-writer"
  count                = "${lookup(local.jarvis_permissions, var.environment)}"
  max_session_duration = 43200

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "AWS": "arn:aws:iam::578510050023:role/twitch-telemetry-writer-master"
      },
      "Action": "sts:AssumeRole"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "twitch_telemetry_writer_policy" {
  name  = "twitch-telemetry-writer-policy"
  count = "${lookup(local.jarvis_permissions, var.environment)}"
  role  = "${aws_iam_role.twitch_telemetry_writer.id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": "cloudwatch:*",
      "Resource": "*"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "follow_permissions1" {
  role       = "${var.iam_id}"
  policy_arn = "${var.dynamodb_iam_policy_arn}"
}

resource "aws_iam_role_policy_attachment" "access_logs_permissions" {
  role       = "${var.iam_id}"
  policy_arn = "${var.access_logs_permissions_arn}"
}

resource "aws_iam_role_policy_attachment" "async_queue_permissions" {
  role       = "${var.iam_id}"
  policy_arn = "${var.async_queue_permissions_arn}"
}
