provider "consul" {
  address    = "api.us-west-2.prod.consul.live-video.a2z.com"
  datacenter = "us-west2"
}

data "template_file" consul {
  template = "${file("${path.module}/tformpipeline.tpl")}"

  vars {
    region          = "${var.region}"
    deploy_aws_role = "${var.deploy_aws_role}"
    aws_creds       = "${var.aws_creds}"
    data            = "${jsonencode(var.data)}"
    promote_from    = "${var.promote_from}"
    auto_promote    = "${var.auto_promote}"
    profile         = "${var.profile}"
    cluster_name    = "${var.cluster_name}"
    service_name    = "${var.service_name}"
  }
}

resource "consul_keys" "app" {
  datacenter = "us-west2"

  key {
    path  = "pipeline/info/${var.team}/${var.service}/${var.environment}"
    value = "${data.template_file.consul.rendered}"
  }
}

data "template_file" jenkins_job {
  template = "${file("${path.module}/jenkins-job.xml.tpl")}"

  vars {
    team        = "${var.team}"
    service     = "${var.service}"
    environment = "${var.environment}"
  }
}

# Set the url of the jenkins runner to target, and optionally override the cred file location
provider "jenkins" {
  url                = "https://jenkins.internal.justin.tv"
  shared_credentials = "${file(pathexpand("~/.jenkins_auth"))}"
}

resource "jenkins_job" "ecs_deploy_job" {
  name           = "${var.team}-${var.service}-${var.environment}"
  job_definition = "${data.template_file.jenkins_job.rendered}"
}