variable "team" {
  description = "Team that created this pipeline"
}

variable "service" {
  description = "Which service of the team's to promote"
}

variable "tag" {
  description = "Which tag starts the promotion pipeline.  Usually, the default value (latest) is what you want."
  default     = "latest"
}

variable "git_repository" {
  description = "Which repository hosts this code."
  default     = ""
}

data "template_file" jenkins_job {
  template = "${file("${path.module}/jenkins-job.xml.tpl")}"

  vars {
    team           = "${var.team}"
    service        = "${var.service}"
    tag            = "${var.tag}"
    git_repository = "${var.git_repository}"
  }
}

# Set the url of the jenkins runner to target, and optionally override the cred file location
provider "jenkins" {
  url                = "https://jenkins.internal.justin.tv"
  shared_credentials = "${file(pathexpand("~/.jenkins_auth"))}"
}

resource "jenkins_job" "promotion_deploy_job" {
  name           = "${var.team}-${var.service}-pipeline"
  job_definition = "${data.template_file.jenkins_job.rendered}"
}
