resource "aws_route53_zone" "a2z" {
  name = "${var.environment}.${var.service}.twitch.a2z.com"
}

resource "aws_route53_record" "test_record" {
  zone_id = "${aws_route53_zone.a2z.zone_id}"
  name    = "_test.${aws_route53_zone.a2z.name}"
  type    = "TXT"
  ttl     = "300"
  records = ["If you're reading this it works"]
}

resource "aws_route53_record" "record" {
  zone_id = "${aws_route53_zone.a2z.zone_id}"
  name    = "${var.environment}.${var.service}.twitch.a2z.com"
  type    = "A"

  alias {
    name                   = "${var.elb_dns_name}"
    zone_id                = "${var.elb_zone_id}"
    evaluate_target_health = false
  }
}

output "zone_id" {
  value = "${aws_route53_zone.a2z.zone_id}"
}

output "elb_domain_name" {
  value = "${aws_route53_record.record.name}"
}
