locals {
  owner = "jlindamo@twitch.tv"
  team  = "feeds"

  service = "graphdb"
}

variable "edge_write_capacity" {}

variable "edge_read_capacity" {}

variable "count_read_capacity" {}

variable "list_to_read_capacity" {}

variable "autoscale_role_arn" {}

variable "edge_name" {}

variable "region1" {}

variable "min_utilization" {
  default = 0.05
}

variable "region2" {}

variable "stream_lambda_arns" {
  type = "map"
}

module dynamodb_region1 {
  source    = "./region"
  edge_name = "${var.edge_name}"

  edge_read_capacity  = "${var.edge_read_capacity}"
  edge_write_capacity = "${var.edge_write_capacity}"
  count_read_capacity = "${var.count_read_capacity}"
  min_utilization     = "${var.min_utilization}"

  list_to_read_capacity = "${var.list_to_read_capacity}"
  autoscale_role_arn    = "${var.autoscale_role_arn}"
  stream_lambda_arn     = "${var.stream_lambda_arns["region1"]}"
  replica_region        = "${var.region2}"
}

output "table_name" {
  value = "${module.dynamodb_region1.edge_dynamodb_name}"
}
