locals {
  owner = "jlindamo@twitch.tv"
  team  = "feeds"

  service = "graphdb"
}

variable "node_name" {
  type        = "string"
  description = "Which type of node to create tables for"
}

variable "node_read_capacity" {
  type        = "string"
  description = "How much read capacity for the node table"
}

variable "node_write_capacity" {
  type        = "string"
  description = "How much write capacity for the node table"
}

variable "list_read_capacity" {
  type        = "string"
  description = "How much read capacity for the list-nodes index"
}

variable "count_read_capacity" {
  type        = "string"
  description = "How much read capacity for the node counts"
}

variable "autoscale_role_arn" {}

variable "region1" {}

variable "stream_lambda_arns" {
  type = "map"
}

variable "min_utilization" {
  default = 0.05
}

variable "region2" {}

module dynamodb_region1 {
  source = "./region"

  node_name           = "${var.node_name}"
  node_write_capacity = "${var.node_write_capacity}"
  count_read_capacity = "${var.count_read_capacity}"
  node_read_capacity  = "${var.node_read_capacity}"
  list_read_capacity  = "${var.list_read_capacity}"
  min_utilization     = "${var.min_utilization}"

  autoscale_role_arn = "${var.autoscale_role_arn}"
  stream_lambda_arn  = "${var.stream_lambda_arns["region1"]}"
  replica_region     = "${var.region2}"
}

output node_dynamodb_name {
  value = "${module.dynamodb_region1.node_dynamodb_name}"
}

output node_count_dynamodb_name {
  value = "${module.dynamodb_region1.node_count_dynamodb_name}"
}
