variable "service" {
  description = "The name of the service.  E.g. feeds-edge, duplo.  This is used with other variables to uniquely name resources."
}

variable "environment" {
  description = "Which env for the service"
}

variable "team" {
  description = "Team name to use to create task definitions"
}

variable "cluster_name" {
  description = "The full name of the ECS cluster.  E.g. feeds-common, events-common"
}

variable "target_group_arn" {
  description = "EC2 target group to link the service to, that the ALB can use to route traffic"
}

variable "task_role_arn" {
  default     = ""
  description = "IAM role to run these task in"
}

variable "container_port" {
  description = "Task's open port that links from the ALB target group (8080)"
}

variable desired_count {
  default     = "1"
  description = "The number of tasks to run in the group."
}

variable service_iam_role {
  description = "IAM role that allows services on the EC2 instance.  NOT the task role.  You usually want .core.service_iam_role"
}
